/*
 * Decompiled with CFR 0.152.
 */
package me.nallar.modpatcher;

import me.nallar.javatransformer.api.JavaTransformer;
import me.nallar.modpatcher.ModPatcher;
import me.nallar.modpatcher.ModPatcherTransformer;
import me.nallar.modpatcher.PatcherLog;

class ModPatcherLoadHook {
    private static final int API_VERSION = 1;
    private static final String VERSION = "1.8.9.101";

    ModPatcherLoadHook() {
    }

    static void loadHook(ModPatcher.Version requiredVersion, String modPatcherRelease, int apiVersion) {
        ModPatcher.Version current;
        PatcherLog.info("Loaded ModPatcher. Version: 1.8.9.101 API version: 1");
        if (1 != apiVersion) {
            PatcherLog.warn("API version mismatch. Expected 1, got " + apiVersion);
            PatcherLog.warn("API was loaded from: " + JavaTransformer.pathFromClass(ModPatcher.class));
        }
        if (ModPatcherLoadHook.isOutdated(current = ModPatcher.Version.of(VERSION), requiredVersion)) {
            String autoUpdate = "\nWill auto-update on next start.";
            if (ModPatcher.neverUpdate()) {
                autoUpdate = "";
            } else {
                JavaTransformer.pathFromClass(ModPatcherTransformer.class).toFile().deleteOnExit();
            }
            throw new RuntimeException("ModPatcher outdated. Have version: 1.8.9.101, requested version: " + requiredVersion + autoUpdate);
        }
    }

    static boolean isOutdated(ModPatcher.Version current, ModPatcher.Version required) {
        return required != ModPatcher.Version.LATEST && current.compareTo(required) < 0;
    }
}

