/*
 * Decompiled with CFR 0.152.
 */
package me.nallar.javatransformer.internal.util;

import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.function.Supplier;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;

public final class CollectionUtil {
    @SafeVarargs
    public static <T> Stream<T> union(Collection<T> ... collections) {
        return CollectionUtil.union(Arrays.asList(collections));
    }

    public static <T> Stream<T> union(Collection<Collection<T>> collections) {
        return collections.stream().flatMap(x -> x == null ? Stream.empty() : x.stream());
    }

    public static <T> Stream<T> stream(Supplier<T> supplier) {
        return CollectionUtil.stream(CollectionUtil.iterable(supplier));
    }

    public static <T> Stream<T> stream(Iterable<T> iterable) {
        if (iterable instanceof Collection) {
            return ((Collection)iterable).stream();
        }
        return StreamSupport.stream(iterable.spliterator(), false);
    }

    public static <T> Iterable<T> iterable(Stream<T> supplier) {
        return supplier::iterator;
    }

    public static <T> Iterable<T> iterable(Supplier<T> supplier) {
        return () -> new IteratorFromSupplier(supplier);
    }

    private CollectionUtil() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }

    private static class IteratorFromSupplier<T>
    implements Iterator<T> {
        private final Supplier<T> supplier;
        private T next;

        public IteratorFromSupplier(Supplier<T> supplier) {
            this.supplier = supplier;
            this.next = supplier.get();
        }

        @Override
        public boolean hasNext() {
            return this.next != null;
        }

        @Override
        public T next() {
            if (this.next == null) {
                throw new NoSuchElementException();
            }
            try {
                T t = this.next;
                return t;
            }
            finally {
                this.next = this.supplier.get();
            }
        }
    }
}

