/*
 * Decompiled with CFR 0.152.
 */
package me.nallar.modpatcher;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import javassist.ClassLoaderPool;
import me.nallar.javapatcher.patcher.Patcher;
import me.nallar.javapatcher.patcher.Patches;
import me.nallar.modpatcher.LaunchClassLoaderUtil;
import me.nallar.modpatcher.PatcherLog;
import me.nallar.modpatcher.mappings.MCPMappings;
import net.minecraft.launchwrapper.IClassTransformer;

public class ModPatcher
implements IClassTransformer {
    public static final ClassLoaderPool pool;
    private static final String MOD_PATCHES_DIRECTORY = "./ModPatches/";
    private static final Patcher patcher;
    private static final String ALREADY_LOADED_PROPERTY_NAME = "nallar.ModPatcher.alreadyLoaded";
    private static final String DUMP_PROPERTY_NAME = "nallar.ModPatcher.dump";
    private static final boolean DUMP;
    private boolean init;

    public static Patcher getPatcher() {
        return patcher;
    }

    public static String getSetupClass() {
        return "me.nallar.modpatcher.ModPatcherSetup";
    }

    private static void recursivelyAddXmlFiles(File directory, Patcher patcher) {
        if (!directory.isDirectory()) {
            return;
        }
        try {
            for (File f : directory.listFiles()) {
                if (f.isDirectory()) {
                    ModPatcher.recursivelyAddXmlFiles(f, patcher);
                    continue;
                }
                if (f.getName().endsWith(".xml")) {
                    patcher.readPatchesFromXmlInputStream(new FileInputStream(f));
                    continue;
                }
                if (!f.getName().endsWith(".json")) continue;
                patcher.readPatchesFromJsonInputStream(new FileInputStream(f));
            }
        }
        catch (IOException e) {
            PatcherLog.warn("Failed to load patch", e);
        }
    }

    public static byte[] postSrgTransformationHook(String name, String transformedName, byte[] originalBytes) {
        LaunchClassLoaderUtil.cacheSrgBytes(transformedName, originalBytes);
        try {
            return patcher.patch(transformedName, originalBytes);
        }
        catch (Throwable t) {
            PatcherLog.error("Failed to patch " + transformedName, t);
            return originalBytes;
        }
    }

    static void modPatcherAsCoreModStartup() {
        File modPatchesDirectory = new File(MOD_PATCHES_DIRECTORY);
        if (!modPatchesDirectory.exists()) {
            modPatchesDirectory.mkdir();
            try {
                Files.copy(ModPatcher.class.getResourceAsStream("/modpatcher.json.example"), new File(modPatchesDirectory, "/modpatcher.json.example").toPath(), StandardCopyOption.REPLACE_EXISTING);
                Files.copy(ModPatcher.class.getResourceAsStream("/modpatcher.xml.example"), new File(modPatchesDirectory, "/modpatcher.xml.example").toPath(), StandardCopyOption.REPLACE_EXISTING);
            }
            catch (IOException e) {
                PatcherLog.warn("Failed to extract example patcher files", e);
            }
        }
    }

    public static IClassTransformer getInstance() {
        return LazyModPatcherHolder.INSTANCE;
    }

    public byte[] transform(String name, String transformedName, byte[] bytes) {
        if (!this.init) {
            this.init = true;
            ModPatcher.getPatcher().logDebugInfo();
        }
        if (DUMP) {
            Path path = Paths.get("./DUMP/" + name, new String[0]);
            try {
                Files.createDirectories(path.getParent(), new FileAttribute[0]);
                Files.write(path, bytes, new OpenOption[0]);
            }
            catch (IOException e) {
                PatcherLog.error("Failed to dump class " + name, e);
            }
        }
        return ModPatcher.postSrgTransformationHook(name, transformedName, bytes);
    }

    static {
        Patcher postSrgPatcher_;
        boolean alreadyLoaded;
        DUMP = !System.getProperty(DUMP_PROPERTY_NAME, "").isEmpty();
        PatcherLog.info("ModPatcher running under classloader " + ModPatcher.class.getClassLoader().getClass().getName());
        boolean bl = alreadyLoaded = System.getProperty(ALREADY_LOADED_PROPERTY_NAME) != null;
        if (alreadyLoaded) {
            PatcherLog.error("Detected multiple classloads of ModPatcher - classloading issue?", new Throwable());
        } else {
            System.setProperty(ALREADY_LOADED_PROPERTY_NAME, "true");
        }
        try {
            pool = new ClassLoaderPool();
            postSrgPatcher_ = new Patcher(pool, Patches.class, new MCPMappings());
        }
        catch (Exception t) {
            PatcherLog.error("Failed to create Patcher", t);
            throw new RuntimeException(t);
        }
        patcher = postSrgPatcher_;
        ModPatcher.recursivelyAddXmlFiles(new File(MOD_PATCHES_DIRECTORY), patcher);
    }

    private static class LazyModPatcherHolder {
        private static final ModPatcher INSTANCE = new ModPatcher();

        private LazyModPatcherHolder() {
        }
    }
}

