/*
 * Decompiled with CFR 0.152.
 */
package me.nallar.modpatcher;

import com.google.common.base.Joiner;
import cpw.mods.fml.relauncher.FMLRelaunchLog;
import java.io.IOException;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import me.nallar.modpatcher.ModPatcher;
import me.nallar.modpatcher.PatcherLog;
import net.minecraft.launchwrapper.IClassNameTransformer;
import net.minecraft.launchwrapper.IClassTransformer;
import net.minecraft.launchwrapper.LaunchClassLoader;
import org.apache.logging.log4j.Level;

public final class LaunchClassLoaderUtil
extends Enum<LaunchClassLoaderUtil> {
    private static final String SPONGEPOWERED_MIXIN_TRANSFORMER_NAME = "org.spongepowered.asm.mixin.transformer.MixinTransformer$Proxy";
    private static final String DEOBF_TRANSFORMER_NAME = "cpw.mods.fml.common.asm.transformers.DeobfuscationTransformer";
    private static final List<String> DEOBF_TRANSFORMER_NAMES;
    private static final List<String> WHITELISTED_TRANSFORMERS;
    private static final boolean DEBUG;
    private static final boolean DEBUG_FINER;
    private static final String ALREADY_LOADED_PROPERTY_NAME = "nallar.LaunchClassLoaderUtil.alreadyLoaded";
    private static final String DUMP_TRANSFORMERS_PROPERTY_NAME = "nallar.LaunchClassLoaderUtil.dumpTransformers";
    private static final String WARN_INCONSISTENT_TRANSFORMATION_PROPERTY_NAME = "nallar.LaunchClassLoaderUtil.warnForInconsistentTransformation";
    private static final HashMap<String, byte[]> cachedSrgClasses;
    static LaunchClassLoader instance;
    private static List<IClassTransformer> transformers;
    private static IClassTransformer[] srgTransformers;
    private static IClassNameTransformer renameTransformer;
    private static Set<String> classLoaderExceptions;
    private static Set<String> transformerExceptions;
    private static boolean warnedForInconsistentTransformation;
    private static final /* synthetic */ LaunchClassLoaderUtil[] $VALUES;

    public static LaunchClassLoaderUtil[] values() {
        return (LaunchClassLoaderUtil[])$VALUES.clone();
    }

    public static LaunchClassLoaderUtil valueOf(String name) {
        return Enum.valueOf(LaunchClassLoaderUtil.class, name);
    }

    public static void addTransformer(IClassTransformer transformer) {
        List<IClassTransformer> transformers = LaunchClassLoaderUtil.getTransformers();
        int target = -1;
        for (int i = 0; i < transformers.size(); ++i) {
            String className;
            IClassTransformer current = transformers.get(i);
            if (current == transformer) {
                transformers.remove(i--);
            }
            if (!DEOBF_TRANSFORMER_NAMES.contains(className = current.getClass().getName())) continue;
            target = i;
        }
        if (target == -1) {
            PatcherLog.warn("Didn't find deobfuscation transformers " + DEOBF_TRANSFORMER_NAMES.toString() + " in transformers list.\nDid you forget to set the SortingIndex for your coremod >= 1001? This message is expected in a deobf environment.");
            transformers.add(transformer);
        } else {
            transformers.add(target + 1, transformer);
        }
        LaunchClassLoaderUtil.buildSrgTransformList();
    }

    public static void dumpTransformersIfEnabled() {
        if (System.getProperty(DUMP_TRANSFORMERS_PROPERTY_NAME) != null) {
            PatcherLog.info("Transformers: " + transformers.toString(), new Throwable());
        }
    }

    public static List<IClassTransformer> getTransformers() {
        if (transformers != null) {
            return transformers;
        }
        try {
            Field f = instance.getClass().getDeclaredField("transformers");
            f.setAccessible(true);
            transformers = (List)f.get(LaunchClassLoaderUtil.getInstance());
            return transformers;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static LaunchClassLoader getInstance() {
        if (instance != null) {
            return instance;
        }
        throw new Error("Tried to retrieve LaunchClassLoader instance before setting up the transformer");
    }

    private static IClassNameTransformer getRenameTransformer() {
        if (renameTransformer != null) {
            return renameTransformer;
        }
        try {
            Field f = instance.getClass().getDeclaredField("renameTransformer");
            f.setAccessible(true);
            renameTransformer = (IClassNameTransformer)f.get(LaunchClassLoaderUtil.getInstance());
            return renameTransformer;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private static Set<String> getClassLoaderExceptions() {
        if (classLoaderExceptions != null) {
            return classLoaderExceptions;
        }
        try {
            Field f = instance.getClass().getDeclaredField("classLoaderExceptions");
            f.setAccessible(true);
            classLoaderExceptions = (Set)f.get(LaunchClassLoaderUtil.getInstance());
            return classLoaderExceptions;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private static Set<String> getTransformerExceptions() {
        if (transformerExceptions != null) {
            return transformerExceptions;
        }
        try {
            Field f = instance.getClass().getDeclaredField("transformerExceptions");
            f.setAccessible(true);
            transformerExceptions = (Set)f.get(LaunchClassLoaderUtil.getInstance());
            return transformerExceptions;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static boolean excluded(String name) {
        for (String exception : LaunchClassLoaderUtil.getClassLoaderExceptions()) {
            if (!name.startsWith(exception)) continue;
            return true;
        }
        return false;
    }

    public static boolean allowedForSrg(String name) {
        return name.startsWith("net.minecraft") || name.startsWith("nallar.") || name.startsWith("me.nallar.");
    }

    private static byte[] runTransformer(String name, String transformedName, byte[] basicClass, IClassTransformer transformer) {
        try {
            return transformer.transform(name, transformedName, basicClass);
        }
        catch (Throwable t) {
            String message = t.getMessage();
            if (message != null && message.contains("for invalid side")) {
                if (t instanceof RuntimeException) {
                    throw (RuntimeException)t;
                }
                if (t instanceof Error) {
                    throw (Error)t;
                }
                throw new RuntimeException(t);
            }
            if (basicClass != null || DEBUG_FINER) {
                FMLRelaunchLog.log((Level)(DEBUG_FINER && basicClass != null ? Level.WARN : Level.TRACE), (Throwable)t, (String)("Failed to transform " + name), (Object[])new Object[0]);
            }
            return basicClass;
        }
    }

    public static void buildSrgTransformList() {
        ArrayList<IClassTransformer> result = new ArrayList<IClassTransformer>();
        List<IClassTransformer> transformers = LaunchClassLoaderUtil.getTransformers();
        for (IClassTransformer transformer : transformers) {
            if (transformer == ModPatcher.getInstance()) {
                srgTransformers = result.toArray(new IClassTransformer[0]);
                return;
            }
            if (LaunchClassLoaderUtil.whitelisted(transformer)) {
                result.add(transformer);
            }
            if (!Objects.equals(transformer.getClass().getName(), DEOBF_TRANSFORMER_NAME)) continue;
            srgTransformers = result.toArray(new IClassTransformer[0]);
            return;
        }
        throw new RuntimeException("No SRG or ModPatcher transformer found when building SRG transformer list. " + Joiner.on((String)",\n").join(transformers));
    }

    private static boolean whitelisted(IClassTransformer transformer) {
        for (String whitelistEntry : WHITELISTED_TRANSFORMERS) {
            if (!transformer.getClass().getName().startsWith(whitelistEntry)) continue;
            return true;
        }
        return false;
    }

    private static byte[] transformUpToSrg(String name, String transformedName, byte[] basicClass) {
        if (srgTransformers == null) {
            throw new RuntimeException("Tried to call transformUpToSrg too early - haven't build SRG transformer list yet");
        }
        for (IClassTransformer transformer : srgTransformers) {
            basicClass = LaunchClassLoaderUtil.runTransformer(name, transformedName, basicClass, transformer);
        }
        return basicClass;
    }

    public static byte[] getSrgBytes(String name) {
        String transformedName = LaunchClassLoaderUtil.transformName(name);
        name = LaunchClassLoaderUtil.untransformName(name);
        if (!LaunchClassLoaderUtil.allowedForSrg(transformedName)) {
            return null;
        }
        byte[] cached = cachedSrgClasses.get(transformedName);
        if (cached != null) {
            return cached;
        }
        try {
            byte[] bytes = LaunchClassLoaderUtil.getClassBytes(name);
            return LaunchClassLoaderUtil.transformUpToSrg(name, transformedName, bytes);
        }
        catch (Throwable t) {
            throw new RuntimeException(t);
        }
    }

    public static void cacheSrgBytes(String transformedName, byte[] bytes) {
        if (!LaunchClassLoaderUtil.allowedForSrg(transformedName)) {
            return;
        }
        byte[] old = cachedSrgClasses.put(transformedName, bytes);
        if (old != null && !Arrays.equals(bytes, old)) {
            ModPatcher.pool.dropCache(transformedName);
            if (LaunchClassLoaderUtil.shouldWarnInconsistentTransformation()) {
                PatcherLog.warn(null, new Error("Inconsistent transformation results. Tried to cache different bytes for class " + transformedName + " to previous result after transformation."));
            }
        }
    }

    private static boolean shouldWarnInconsistentTransformation() {
        if (System.getProperty(WARN_INCONSISTENT_TRANSFORMATION_PROPERTY_NAME) != null) {
            return true;
        }
        if (!warnedForInconsistentTransformation) {
            warnedForInconsistentTransformation = true;
            PatcherLog.warn("One or more classes have inconsistent transformation results. To enable logging of this, add -Dnallar.LaunchClassLoaderUtil.warnForInconsistentTransformation=true to your JVM parameters.");
        }
        return false;
    }

    public static byte[] getClassBytes(String name) {
        if (name.startsWith("java/")) {
            return null;
        }
        try {
            return LaunchClassLoaderUtil.getInstance().getClassBytes(name);
        }
        catch (IOException e) {
            return null;
        }
    }

    public static String transformName(String name) {
        return LaunchClassLoaderUtil.getRenameTransformer().remapClassName(name);
    }

    public static String untransformName(String name) {
        return LaunchClassLoaderUtil.getRenameTransformer().unmapClassName(name);
    }

    static {
        boolean alreadyLoaded;
        $VALUES = new LaunchClassLoaderUtil[0];
        DEOBF_TRANSFORMER_NAMES = Arrays.asList(DEOBF_TRANSFORMER_NAME, SPONGEPOWERED_MIXIN_TRANSFORMER_NAME);
        WHITELISTED_TRANSFORMERS = Arrays.asList("cpw.mods.fml.common.asm.transformers.PatchingTransformer", DEOBF_TRANSFORMER_NAME);
        DEBUG = Boolean.parseBoolean(System.getProperty("legacy.debugClassLoading", "false"));
        DEBUG_FINER = DEBUG && Boolean.parseBoolean(System.getProperty("legacy.debugClassLoadingFiner", "false"));
        cachedSrgClasses = new HashMap();
        boolean bl = alreadyLoaded = System.getProperty(ALREADY_LOADED_PROPERTY_NAME) != null;
        if (alreadyLoaded) {
            PatcherLog.error("Detected multiple classloads of LaunchClassLoaderUtil - classloading issue?", new Throwable());
        } else {
            System.setProperty(ALREADY_LOADED_PROPERTY_NAME, "true");
        }
    }
}

