/*
 * Decompiled with CFR 0.152.
 */
package me.nallar.modpatcher.api;

import LZMA.LzmaInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Field;
import java.nio.file.CopyOption;
import java.nio.file.FileSystem;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.NoSuchFileException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import me.nallar.modpatcher.api.ModPatcherTransformer;
import me.nallar.modpatcher.api.PatcherLog;
import net.minecraft.launchwrapper.IClassNameTransformer;
import net.minecraft.launchwrapper.IClassTransformer;
import net.minecraft.launchwrapper.LaunchClassLoader;

public final class LaunchClassLoaderUtil
extends Enum<LaunchClassLoaderUtil> {
    private static final boolean DUMP_JAVASSIST_LOADED_CLASSES;
    private static final String ALREADY_LOADED_PROPERTY_NAME = "nallar.LaunchClassLoaderUtil.alreadyLoaded";
    private static final String DUMP_TRANSFORMERS_PROPERTY_NAME = "nallar.LaunchClassLoaderUtil.dumpTransformers";
    private static final String WARN_INCONSISTENT_TRANSFORMATION_PROPERTY_NAME = "nallar.LaunchClassLoaderUtil.warnForInconsistentTransformation";
    private static final HashMap<String, byte[]> cachedSrgClasses;
    static LaunchClassLoader instance;
    private static List<IClassTransformer> transformers;
    private static IClassNameTransformer renameTransformer;
    private static Set<String> classLoaderExceptions;
    private static Set<String> transformerExceptions;
    private static boolean warnedForInconsistentTransformation;
    private static FileSystem stubs;
    private static final /* synthetic */ LaunchClassLoaderUtil[] $VALUES;

    public static LaunchClassLoaderUtil[] values() {
        return (LaunchClassLoaderUtil[])$VALUES.clone();
    }

    public static LaunchClassLoaderUtil valueOf(String name) {
        return Enum.valueOf(LaunchClassLoaderUtil.class, name);
    }

    public static void addTransformer(IClassTransformer transformer) {
        List<IClassTransformer> transformers = LaunchClassLoaderUtil.getTransformers();
        transformers.remove(transformer);
        transformers.add(transformer);
    }

    public static void dumpTransformersIfEnabled() {
        if (!"false".equalsIgnoreCase(System.getProperty(DUMP_TRANSFORMERS_PROPERTY_NAME))) {
            PatcherLog.info("Transformers: " + transformers.toString());
        }
    }

    public static List<IClassTransformer> getTransformers() {
        if (transformers != null) {
            return transformers;
        }
        try {
            Field f = instance.getClass().getDeclaredField("transformers");
            f.setAccessible(true);
            transformers = (List)f.get(LaunchClassLoaderUtil.getInstance());
            return transformers;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static LaunchClassLoader getInstance() {
        if (instance != null) {
            return instance;
        }
        throw new Error("Tried to retrieve LaunchClassLoader instance before setting up the transformer");
    }

    private static IClassNameTransformer getRenameTransformer() {
        if (renameTransformer != null) {
            return renameTransformer;
        }
        try {
            Field f = instance.getClass().getDeclaredField("renameTransformer");
            f.setAccessible(true);
            renameTransformer = (IClassNameTransformer)f.get(LaunchClassLoaderUtil.getInstance());
            return renameTransformer;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private static Set<String> getClassLoaderExceptions() {
        if (classLoaderExceptions != null) {
            return classLoaderExceptions;
        }
        try {
            Field f = instance.getClass().getDeclaredField("classLoaderExceptions");
            f.setAccessible(true);
            classLoaderExceptions = (Set)f.get(LaunchClassLoaderUtil.getInstance());
            return classLoaderExceptions;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private static Set<String> getTransformerExceptions() {
        if (transformerExceptions != null) {
            return transformerExceptions;
        }
        try {
            Field f = instance.getClass().getDeclaredField("transformerExceptions");
            f.setAccessible(true);
            transformerExceptions = (Set)f.get(LaunchClassLoaderUtil.getInstance());
            return transformerExceptions;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static boolean allowedForSrg(String name) {
        return !name.startsWith("java.") && !name.startsWith("javax.");
    }

    private static byte[] transformUpToSrg(String name, String transformedName, byte[] basicClass) {
        if (basicClass == null) {
            return null;
        }
        IClassNameTransformer renameTransformer = LaunchClassLoaderUtil.getRenameTransformer();
        if (renameTransformer == null) {
            throw new RuntimeException("Tried to call transformUpToSrg too early - haven't built SRG transformer list yet");
        }
        return ((IClassTransformer)renameTransformer).transform(name, transformedName, basicClass);
    }

    private static String classNameToResourceName(String name) {
        return name.replace('.', '/') + ".class";
    }

    private static byte[] getStubSrgBytes(String name) {
        if (stubs == null) {
            Path extracted = Paths.get("./libraries/minecraft_stubs.jar", new String[0]);
            if (!Files.exists(extracted, new LinkOption[0])) {
                if (!Files.isDirectory(extracted.getParent(), new LinkOption[0])) {
                    Files.createDirectory(extracted.getParent(), new FileAttribute[0]);
                }
                Files.copy((InputStream)new LzmaInputStream(LaunchClassLoaderUtil.class.getResourceAsStream("/minecraft_stubs.jar.lzma")), extracted, new CopyOption[0]);
            }
            stubs = FileSystems.newFileSystem(extracted, null);
        }
        try {
            return Files.readAllBytes(stubs.getPath(LaunchClassLoaderUtil.classNameToResourceName(name), new String[0]));
        }
        catch (NoSuchFileException ignored) {
            return null;
        }
    }

    public static byte[] getSrgBytes(String name, boolean allowRetransform) {
        byte[] cached;
        String transformedName = LaunchClassLoaderUtil.transformName(name);
        name = LaunchClassLoaderUtil.untransformName(name);
        if (!LaunchClassLoaderUtil.allowedForSrg(transformedName)) {
            return null;
        }
        if (DUMP_JAVASSIST_LOADED_CLASSES) {
            PatcherLog.warn("Need to retransform " + transformedName + " to get SRG bytes", new Throwable());
        }
        if ((cached = cachedSrgClasses.get(transformedName)) != null || !allowRetransform) {
            return cached;
        }
        byte[] stubBytes = LaunchClassLoaderUtil.getStubSrgBytes(transformedName);
        if (stubBytes != null) {
            return stubBytes;
        }
        try {
            byte[] bytes = LaunchClassLoaderUtil.getClassBytes(name);
            if (name.equals(transformedName)) {
                return bytes;
            }
            return LaunchClassLoaderUtil.transformUpToSrg(name, transformedName, bytes);
        }
        catch (Throwable t) {
            throw new RuntimeException(t);
        }
    }

    public static void cacheSrgBytes(String transformedName, byte[] bytes) {
        if (!LaunchClassLoaderUtil.allowedForSrg(transformedName)) {
            return;
        }
        byte[] old = cachedSrgClasses.put(transformedName, bytes);
        if (old != null && !Arrays.equals(bytes, old)) {
            ModPatcherTransformer.pool.dropCache(transformedName, false);
            if (LaunchClassLoaderUtil.shouldWarnInconsistentTransformation()) {
                PatcherLog.warn(null, new Error("Inconsistent transformation results. Tried to cache different bytes for class " + transformedName + " to previous result after transformation."));
            }
        }
    }

    private static boolean shouldWarnInconsistentTransformation() {
        if (System.getProperty(WARN_INCONSISTENT_TRANSFORMATION_PROPERTY_NAME) != null) {
            return true;
        }
        if (!warnedForInconsistentTransformation) {
            warnedForInconsistentTransformation = true;
            PatcherLog.warn("One or more classes have inconsistent transformation results. To enable logging of this, add -Dnallar.LaunchClassLoaderUtil.warnForInconsistentTransformation=true to your JVM parameters.");
        }
        return false;
    }

    public static byte[] getClassBytes(String name) {
        if (name.startsWith("java/")) {
            return null;
        }
        try {
            return LaunchClassLoaderUtil.getInstance().getClassBytes(name);
        }
        catch (IOException e) {
            return null;
        }
    }

    public static String transformName(String name) {
        return LaunchClassLoaderUtil.getRenameTransformer().remapClassName(name);
    }

    public static String untransformName(String name) {
        return LaunchClassLoaderUtil.getRenameTransformer().unmapClassName(name);
    }

    public static void removeRedundantExclusions() {
        LaunchClassLoaderUtil.removeRedundantExclusions(LaunchClassLoaderUtil.getTransformerExceptions());
        LaunchClassLoaderUtil.removeRedundantExclusions(LaunchClassLoaderUtil.getClassLoaderExceptions());
    }

    static void removeRedundantExclusions(Set<String> transformerExceptions) {
        HashSet<String> old = new HashSet<String>(transformerExceptions);
        for (String exclusion : old) {
            for (String exclusion2 : old) {
                if (exclusion.equals(exclusion2) || !exclusion.startsWith(exclusion2)) continue;
                transformerExceptions.remove(exclusion);
            }
        }
    }

    public static void releaseSrgBytes(String transformedName) {
        cachedSrgClasses.remove(transformedName);
        ModPatcherTransformer.pool.dropCache(transformedName, true);
    }

    static {
        boolean alreadyLoaded;
        $VALUES = new LaunchClassLoaderUtil[0];
        DUMP_JAVASSIST_LOADED_CLASSES = Boolean.parseBoolean(System.getProperty("nallar.LaunchClassLoaderUtil.dumpJavassistLoadedClasses", "false"));
        cachedSrgClasses = new HashMap();
        boolean bl = alreadyLoaded = System.getProperty(ALREADY_LOADED_PROPERTY_NAME) != null;
        if (alreadyLoaded) {
            PatcherLog.error("Detected multiple classloads of LaunchClassLoaderUtil - classloading issue?", new Throwable());
        } else {
            System.setProperty(ALREADY_LOADED_PROPERTY_NAME, "true");
        }
    }
}

