/*
 * Decompiled with CFR 0.152.
 */
package me.nallar.modpatcher.api;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLStreamHandler;
import javassist.ClassPath;
import javassist.ClassPool;
import javassist.CtClass;
import javassist.NotFoundException;
import me.nallar.modpatcher.api.LaunchClassLoaderUtil;
import me.nallar.modpatcher.api.PatcherLog;

public class ClassLoaderPool
extends ClassPool {
    ClassLoaderPool() {
        this.appendClassPath(new LaunchClassLoaderPath());
        this.appendSystemPath();
        this.importPackage("java.util");
    }

    public CtClass getCached(String className) {
        return super.getCached(className);
    }

    protected synchronized CtClass get0(String className, boolean useCache) throws NotFoundException {
        return super.get0(className, true);
    }

    void dropCache(String name, boolean allowFailure) {
        if (this.classes.remove(name) == null && !allowFailure) {
            PatcherLog.warn("Failed to drop " + name + " from cache. Currently cached: " + this.classes.keySet().toString());
        }
    }

    private class LaunchClassLoaderPath
    implements ClassPath {
        private LaunchClassLoaderPath() {
        }

        public InputStream openClassfile(String className) throws NotFoundException {
            byte[] bytes = LaunchClassLoaderUtil.getSrgBytes(className, true);
            if (bytes == null) {
                return null;
            }
            return new ByteArrayInputStream(bytes);
        }

        public URL find(String className) {
            byte[] bytes = LaunchClassLoaderUtil.getSrgBytes(className, true);
            if (bytes == null) {
                return null;
            }
            return new URL(null, "runtimeclass:" + className.replace(".", "/"), new Handler(bytes));
        }

        public void close() {
        }
    }

    public static class Handler
    extends URLStreamHandler {
        final byte[] data;

        Handler(byte[] data) {
            this.data = data;
        }

        @Override
        protected URLConnection openConnection(URL u) throws IOException {
            return new MockHttpURLConnection(u, this.data);
        }

        public static class MockHttpURLConnection
        extends HttpURLConnection {
            private final byte[] data;

            MockHttpURLConnection(URL url, byte[] data) {
                super(url);
                this.data = data;
            }

            @Override
            public InputStream getInputStream() throws IOException {
                return new ByteArrayInputStream(this.data);
            }

            @Override
            public void connect() throws IOException {
                throw new UnsupportedOperationException();
            }

            @Override
            public void disconnect() {
                throw new UnsupportedOperationException();
            }

            @Override
            public boolean usingProxy() {
                return false;
            }
        }
    }
}

