/*
 * Decompiled with CFR 0.152.
 */
package me.nallar.javatransformer.internal.util;

import java.util.ArrayList;
import java.util.List;
import java.util.function.Supplier;
import java.util.stream.Stream;
import me.nallar.javatransformer.api.TransformationException;
import me.nallar.javatransformer.internal.util.CollectionUtil;

public final class TypeUtil {
    public static List<String> splitTypes(String signature, boolean isSignature) {
        String type;
        if (signature == null) {
            return null;
        }
        ArrayList<String> types = new ArrayList<String>();
        for (int pos = 0; pos < signature.length(); pos += type.length()) {
            type = TypeUtil.readType(signature, pos, isSignature);
            types.add(type);
        }
        return types;
    }

    public static Stream<String> readTypes(final String in, final boolean isSignature) {
        return CollectionUtil.stream(new Supplier<String>(){
            int pos = 0;

            @Override
            public String get() {
                if (this.pos < in.length()) {
                    String next = TypeUtil.readType(in, this.pos, isSignature);
                    this.pos += next.length();
                    return next;
                }
                return null;
            }
        });
    }

    public static String readType(String in, int pos, boolean isSignature) {
        int startPos = pos;
        String current = "";
        block11: while (pos < in.length()) {
            char c = in.charAt(pos++);
            switch (c) {
                case 'B': 
                case 'C': 
                case 'D': 
                case 'F': 
                case 'I': 
                case 'J': 
                case 'S': 
                case 'V': 
                case 'Z': {
                    return current + c;
                }
                case '[': {
                    current = current + '[';
                    continue block11;
                }
                case 'T': {
                    int end = in.indexOf(59, pos);
                    String name = in.substring(pos, end);
                    return current + 'T' + name + ';';
                }
                case 'L': {
                    int start = pos;
                    int genericCount = 0;
                    while (pos < in.length()) {
                        switch (in.charAt(pos++)) {
                            case ';': {
                                if (genericCount > 0) break;
                                String name = in.substring(start, pos);
                                return current + 'L' + name;
                            }
                            case '<': {
                                if (!isSignature) {
                                    throw new TransformationException("Illegal character '<' in descriptor: " + in);
                                }
                                ++genericCount;
                                break;
                            }
                            case '>': {
                                --genericCount;
                            }
                        }
                    }
                    continue block11;
                }
            }
            throw new TransformationException("Unexpected character '" + c + "' in signature/descriptor '" + in + "' Searched section '" + in.substring(startPos, pos) + "'");
        }
        throw new StringIndexOutOfBoundsException(pos);
    }

    private TypeUtil() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

