/*
 * Decompiled with CFR 0.152.
 */
package javassist;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLStreamHandler;
import javassist.CannotCompileException;
import javassist.ClassPool;
import javassist.CtClass;
import javassist.NotFoundException;
import me.nallar.modpatcher.api.LaunchClassLoaderUtil;
import me.nallar.modpatcher.api.PatcherLog;

public class ClassLoaderPool
extends ClassPool {
    public ClassLoaderPool() {
        this.appendSystemPath();
        this.importPackage("java.util");
    }

    public CtClass getCached(String className) {
        return super.getCached(className);
    }

    protected synchronized CtClass get0(String className, boolean useCache) throws NotFoundException {
        return super.get0(className, true);
    }

    private byte[] getClassBytesRuntime(String className, boolean allowReTransform) {
        try {
            return LaunchClassLoaderUtil.getSrgBytes(className, allowReTransform);
        }
        catch (RuntimeException e) {
            if (e.getMessage().contains("No SRG transformer")) {
                throw new RuntimeException("Classloader used to load LaunchClassLoader: " + LaunchClassLoaderUtil.getInstance().getClass().getClassLoader(), e);
            }
            throw e;
        }
    }

    public URL find(String className) {
        if (!className.contains(".")) {
            return null;
        }
        byte[] bytes = this.getClassBytesRuntime(className, true);
        if (bytes != null) {
            try {
                return new URL(null, "runtimeclass:" + className.replace(".", "/"), new Handler(bytes));
            }
            catch (MalformedURLException e) {
                PatcherLog.error("Failed to make fake URL for " + className, e);
            }
        }
        return this.source.find(className);
    }

    InputStream openClassfile(String className) throws NotFoundException {
        byte[] bytes = this.getClassBytesRuntime(className, true);
        if (bytes != null) {
            return new ByteArrayInputStream(bytes);
        }
        return this.source.openClassfile(className);
    }

    void writeClassfile(String className, OutputStream out) throws NotFoundException, IOException, CannotCompileException {
        byte[] bytes = this.getClassBytesRuntime(className, false);
        if (bytes != null) {
            out.write(bytes);
        } else {
            this.source.writeClassfile(className, out);
        }
    }

    public void dropCache(String name, boolean allowFailure) {
        if (this.classes.remove(name) == null && !allowFailure) {
            PatcherLog.warn("Failed to drop " + name + " from cache. Currently cached: " + this.classes.keySet().toString());
        }
    }

    public static class Handler
    extends URLStreamHandler {
        final byte[] data;

        Handler(byte[] data) {
            this.data = data;
        }

        @Override
        protected URLConnection openConnection(URL u) throws IOException {
            return new MockHttpURLConnection(u, this.data);
        }

        public static class MockHttpURLConnection
        extends HttpURLConnection {
            private final byte[] data;

            MockHttpURLConnection(URL url, byte[] data) {
                super(url);
                this.data = data;
            }

            @Override
            public InputStream getInputStream() throws IOException {
                return new ByteArrayInputStream(this.data);
            }

            @Override
            public void connect() throws IOException {
                throw new UnsupportedOperationException();
            }

            @Override
            public void disconnect() {
                throw new UnsupportedOperationException();
            }

            @Override
            public boolean usingProxy() {
                return false;
            }
        }
    }
}

