/*
 * Decompiled with CFR 0.152.
 */
package me.nallar.modpatcher.internal;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import javassist.ClassLoaderPool;
import me.nallar.javapatcher.patcher.Patcher;
import me.nallar.javapatcher.patcher.Patches;
import me.nallar.mixin.internal.MixinApplicator;
import me.nallar.modpatcher.internal.LaunchClassLoaderUtil;
import me.nallar.modpatcher.internal.MCPMappings;
import me.nallar.modpatcher.internal.ModPatcherTweaker;
import me.nallar.modpatcher.internal.PatcherLog;
import net.minecraft.launchwrapper.IClassTransformer;
import net.minecraft.launchwrapper.LaunchClassLoader;

public class ModPatcherTransformer {
    public static final ClassLoaderPool pool;
    private static final String MOD_PATCHES_DIRECTORY = "./ModPatches/";
    private static final Patcher patcher;
    private static final String ALREADY_LOADED_PROPERTY_NAME = "nallar.ModPatcher.alreadyLoaded";
    private static final String DUMP_PROPERTY_NAME = "nallar.ModPatcher.dump";
    private static final boolean DUMP;
    private static boolean classLoaderInitialised;
    private static MixinApplicator mixinApplicator;

    private static Error logError(String message, Throwable t) {
        PatcherLog.error(message, t);
        return new Error(message, t);
    }

    private static void checkForMultipleClassLoads() {
        if (System.getProperty(ALREADY_LOADED_PROPERTY_NAME) != null) {
            Error e = ModPatcherTransformer.logError("Detected multiple classloads of ModPatcher - classloading issue?", new Throwable());
            if (!System.getProperty(ALREADY_LOADED_PROPERTY_NAME).equals("breakEverything")) {
                throw e;
            }
        } else {
            System.setProperty(ALREADY_LOADED_PROPERTY_NAME, "true");
        }
    }

    public static Patcher getPatcher() {
        return patcher;
    }

    private static void recursivelyAddXmlFiles(File directory, Patcher patcher) {
        File[] files = directory.listFiles();
        if (files == null) {
            return;
        }
        try {
            for (File f : files) {
                if (f.isDirectory()) {
                    ModPatcherTransformer.recursivelyAddXmlFiles(f, patcher);
                    continue;
                }
                if (f.getName().endsWith(".xml")) {
                    patcher.readPatchesFromXmlInputStream(new FileInputStream(f));
                    continue;
                }
                if (!f.getName().endsWith(".json")) continue;
                patcher.readPatchesFromJsonInputStream(new FileInputStream(f));
            }
        }
        catch (IOException e) {
            PatcherLog.warn("Failed to load patch", e);
        }
    }

    static IClassTransformer getInstance() {
        return ClassTransformer.INSTANCE;
    }

    public static void initialiseClassLoader(LaunchClassLoader classLoader) {
        if (classLoaderInitialised) {
            return;
        }
        classLoaderInitialised = true;
        LaunchClassLoaderUtil.instance = classLoader;
        ModPatcherTweaker.add();
        LaunchClassLoaderUtil.addTransformer(ModPatcherTransformer.getInstance());
        LaunchClassLoaderUtil.dumpTransformersIfEnabled();
        LaunchClassLoaderUtil.removeRedundantExclusions();
    }

    public static String getDefaultPatchesDirectory() {
        return MOD_PATCHES_DIRECTORY;
    }

    public static MixinApplicator getMixinApplicator() {
        MixinApplicator mixinApplicator = ModPatcherTransformer.mixinApplicator;
        if (mixinApplicator == null) {
            ModPatcherTransformer.mixinApplicator = mixinApplicator = new MixinApplicator();
            mixinApplicator.setMakeAccessible(false);
            mixinApplicator.setNoMixinIsError(true);
            mixinApplicator.setLog(PatcherLog::info);
        }
        return mixinApplicator;
    }

    static {
        DUMP = !System.getProperty(DUMP_PROPERTY_NAME, "").isEmpty();
        classLoaderInitialised = false;
        PatcherLog.info("ModPatcher running under classloader " + ModPatcherTransformer.class.getClassLoader().getClass().getName());
        ModPatcherTransformer.checkForMultipleClassLoads();
        try {
            pool = new ClassLoaderPool();
            patcher = new Patcher(pool, Patches.class, new MCPMappings());
            ModPatcherTransformer.recursivelyAddXmlFiles(new File(MOD_PATCHES_DIRECTORY), patcher);
        }
        catch (Throwable t) {
            throw ModPatcherTransformer.logError("Failed to create Patcher", t);
        }
    }

    private static class ClassTransformer
    implements IClassTransformer {
        static IClassTransformer INSTANCE = new ClassTransformer();
        private boolean init;

        private ClassTransformer() {
        }

        private static void dumpIfEnabled(String name, byte[] data) {
            if (!DUMP || !name.contains("net.minecraft")) {
                return;
            }
            Path path = Paths.get("./DUMP/" + name + ".class", new String[0]);
            try {
                Files.createDirectories(path.getParent(), new FileAttribute[0]);
                Files.write(path, data, new OpenOption[0]);
            }
            catch (IOException e) {
                PatcherLog.error("Failed to dump class " + name, e);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public byte[] transform(String name, String transformedName, byte[] bytes) {
            if (!this.init) {
                this.init = true;
                patcher.logDebugInfo();
            }
            ClassTransformer.dumpIfEnabled(transformedName + "_unpatched", bytes);
            byte[] originalBytes = bytes;
            MixinApplicator mixinApplicator = mixinApplicator;
            if (mixinApplicator != null) {
                bytes = mixinApplicator.getMixinTransformer().transformClass(() -> originalBytes, transformedName).get();
            }
            LaunchClassLoaderUtil.cacheSrgBytes(transformedName, bytes);
            try {
                bytes = patcher.patch(transformedName, bytes);
            }
            catch (Throwable t) {
                PatcherLog.error("Failed to patch " + transformedName, t);
            }
            finally {
                LaunchClassLoaderUtil.releaseSrgBytes(transformedName);
            }
            if (originalBytes != bytes) {
                ClassTransformer.dumpIfEnabled(transformedName, bytes);
            }
            return bytes;
        }
    }
}

