/*
 * Decompiled with CFR 0.152.
 */
package me.nallar.modpatcher.api;

import java.io.FileNotFoundException;
import java.io.IOError;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Field;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.Map;
import java.util.Scanner;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Future;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import me.nallar.javapatcher.patcher.Patcher;
import me.nallar.modpatcher.internal.ModPatcherLoadHook;
import me.nallar.modpatcher.internal.ModPatcherTransformer;
import net.minecraft.launchwrapper.LaunchClassLoader;
import net.minecraftforge.fml.relauncher.ReflectionHelper;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ModPatcher {
    private static final int API_VERSION = 2;
    private static final Logger log = LogManager.getLogger((String)"ModPatcher");
    private static final String MODPATCHER_LIB_NAME = "ModPatcher.jlib";
    private static final Path modPatcherPath = ModPatcher.realPath("mods/ModPatcher.jlib");
    private static final String MODPATCHER_API_PACKAGE = "me.nallar.modpatcher.api";
    private static final String MODPATCHER_INTERNAL_PACKAGE = "me.nallar.modpatcher.internal";
    private static final Map<URL, Future<Version>> requestedVersions = new ConcurrentHashMap<URL, Future<Version>>();
    private static boolean checked = false;

    public static String getSetupClass() {
        return "me.nallar.modpatcher.api.ModPatcherSetup";
    }

    public static void requireVersion(URL modpatcher) {
        requestedVersions.put(modpatcher, CompletableFuture.supplyAsync(() -> ModPatcher.getVersion(modpatcher)));
    }

    public static void loadPatches(InputStream inputStream) {
        ModPatcher.checkClassLoading();
        ModPatcherTransformer.getPatcher().loadPatches(inputStream);
    }

    public static void loadPatches(String patches) {
        ModPatcher.checkClassLoading();
        ModPatcherTransformer.getPatcher().loadPatches(patches);
    }

    @Deprecated
    public static Patcher getPatcher() {
        ModPatcher.checkClassLoading();
        return ModPatcherTransformer.getPatcher();
    }

    public static void loadMixins(String mixinPackage) {
        ModPatcher.checkClassLoading();
        ModPatcherTransformer.getMixinApplicator().addSource(mixinPackage);
    }

    public static void loadMixins(Path path) {
        ModPatcher.checkClassLoading();
        ModPatcherTransformer.getMixinApplicator().addSource(path);
    }

    public static void loadMixins(Path path, String packageName) {
        ModPatcher.checkClassLoading();
        ModPatcherTransformer.getMixinApplicator().addSource(path, packageName);
    }

    public static String getDefaultPatchesDirectory() {
        ModPatcher.checkClassLoading();
        return ModPatcherTransformer.getDefaultPatchesDirectory();
    }

    private static Path realPath(String s) {
        Path absolute = Paths.get(s, new String[0]).toAbsolutePath();
        try {
            return absolute.toRealPath(new LinkOption[0]);
        }
        catch (IOException e) {
            return absolute;
        }
    }

    private static void loadModPatcher() {
        ModPatcher.update();
        LaunchClassLoader classLoader = ModPatcher.addToCurrentClassLoader();
        ModPatcher.checkClassLoading(false);
        ModPatcherTransformer.initialiseClassLoader(classLoader);
    }

    private static LaunchClassLoader addToCurrentClassLoader() {
        ClassLoader cl = ModPatcher.class.getClassLoader();
        try {
            URL url = modPatcherPath.toUri().toURL();
            log.trace("Adding " + url + " to classloader");
            if (!(cl instanceof LaunchClassLoader)) {
                throw new UnsupportedOperationException("Should be running under LaunchClassLoader");
            }
            LaunchClassLoader lcl = (LaunchClassLoader)cl;
            lcl.addClassLoaderExclusion(MODPATCHER_INTERNAL_PACKAGE);
            lcl.addClassLoaderExclusion("javassist.");
            lcl.addClassLoaderExclusion("com.github.javaparser.");
            lcl.addClassLoaderExclusion("me.nallar.whocalled.");
            lcl.addClassLoaderExclusion("me.nallar.javatransformer.");
            lcl.addClassLoaderExclusion("me.nallar.javapatcher.");
            lcl.addClassLoaderExclusion("me.nallar.mixin.");
            lcl.addTransformerExclusion(MODPATCHER_API_PACKAGE);
            Field parent = LaunchClassLoader.class.getDeclaredField("parent");
            parent.setAccessible(true);
            parent.set(lcl, new JLibClassLoader((ClassLoader)parent.get(lcl), url));
            boolean cclInvalidNegativeCleared = false;
            try {
                lcl.clearFailures(ModPatcher::removeModPatcherEntries);
                cclInvalidNegativeCleared = true;
            }
            catch (NoClassDefFoundError | NoSuchMethodError linkageError) {
                // empty catch block
            }
            if (!cclInvalidNegativeCleared) {
                Set invalidClasses = (Set)ReflectionHelper.getPrivateValue(LaunchClassLoader.class, (Object)lcl, (String[])new String[]{"invalidClasses"});
                Set negativeResources = (Set)ReflectionHelper.getPrivateValue(LaunchClassLoader.class, (Object)lcl, (String[])new String[]{"negativeResourceCache"});
                invalidClasses.removeIf(ModPatcher::removeModPatcherEntries);
                negativeResources.removeIf(ModPatcher::removeModPatcherEntries);
            }
            log.trace("Loaded class: " + Class.forName("me.nallar.modpatcher.internal.ModPatcherLoadHook"));
            return lcl;
        }
        catch (Exception e) {
            throw new Error(e);
        }
    }

    private static boolean removeModPatcherEntries(String entry) {
        return entry.replace('/', '.').startsWith(MODPATCHER_INTERNAL_PACKAGE);
    }

    private static void update() {
        Version version;
        Version current = version = ModPatcher.getLastVersion();
        URL url = null;
        for (Map.Entry<URL, Future<Version>> entry : requestedVersions.entrySet()) {
            URL entryUrl = entry.getKey();
            Version entryVersion = entry.getValue().get();
            if (entryVersion.compareTo(version) <= 0) continue;
            version = entryVersion;
            url = entryUrl;
        }
        if (url == null) {
            return;
        }
        log.info("Current modpatcher version: " + current);
        log.info("Extracting new version " + version + " from " + url);
        try (InputStream in = url.openConnection().getInputStream();){
            Files.deleteIfExists(modPatcherPath);
            Files.createDirectories(modPatcherPath.getParent(), new FileAttribute[0]);
            Files.copy(in, modPatcherPath, new CopyOption[0]);
        }
        catch (IOException e) {
            log.error("Failed to download ModPatcher", (Throwable)e);
        }
    }

    static void checkClassLoading() {
        ModPatcher.checkClassLoading(true);
    }

    private static void checkClassLoading(boolean load) {
        if (checked) {
            return;
        }
        try {
            Class.forName("me.nallar.modpatcher.internal.ModPatcherLoadHook");
            ModPatcherLoadHook.loadHook(2);
            checked = true;
        }
        catch (ClassNotFoundException | NoClassDefFoundError e) {
            if (!load) {
                throw new Error(e);
            }
            ModPatcher.loadModPatcher();
        }
    }

    static Version getLastVersion() {
        if (!Files.exists(modPatcherPath, new LinkOption[0])) {
            return Version.NONE;
        }
        try {
            return ModPatcher.getVersion(modPatcherPath.toUri().toURL());
        }
        catch (MalformedURLException e) {
            throw new IOError(e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static Version getVersion(URL url) {
        try (ZipInputStream zis = new ZipInputStream(url.openStream());){
            ZipEntry e;
            while ((e = zis.getNextEntry()) != null) {
                if (!"modpatcher.version".equals(e.getName())) continue;
                Scanner s = new Scanner(zis).useDelimiter("\\A");
                Version version = new Version(s.hasNext() ? s.next() : "");
                return version;
            }
            throw new IOError(new FileNotFoundException("modpatcher.version in " + url));
        }
        catch (IOException e) {
            throw new IOError(e);
        }
    }

    static class JLibClassLoader
    extends URLClassLoader {
        private final ClassLoader parent;

        JLibClassLoader(ClassLoader parent, URL ... urls) {
            super(urls, (ClassLoader)null);
            this.parent = parent;
        }

        @Override
        public Class<?> findClass(String name) throws ClassNotFoundException {
            Class<?> loaded = super.findLoadedClass(name);
            if (loaded != null) {
                return loaded;
            }
            try {
                return super.findClass(name);
            }
            catch (ClassNotFoundException e) {
                return this.parent.loadClass(name);
            }
        }

        static {
            ClassLoader.registerAsParallelCapable();
        }
    }

    public static class Version
    implements Comparable<Version> {
        static final Version LATEST = new Version(String.valueOf(Integer.MAX_VALUE));
        static final Version NONE = new Version("0");
        private String version;
        private boolean snapshot;

        private Version(String version) {
            if (version == null) {
                throw new IllegalArgumentException("Version can not be null");
            }
            if ((version = version.trim()).endsWith("-SNAPSHOT")) {
                version = version.replace("-SNAPSHOT", "");
                this.snapshot = true;
            }
            if (!version.matches("[0-9]+(\\.[0-9]+)*")) {
                throw new IllegalArgumentException("Invalid version format. Should consist entirely of digits and dots. Got '" + version + "'");
            }
            this.version = version;
        }

        public static Version of(String s) {
            if (s.equalsIgnoreCase("latest")) {
                return LATEST;
            }
            return new Version(s);
        }

        @Override
        public int compareTo(Version that) {
            if (that == null) {
                return 1;
            }
            if (this == that || this.version.equals(that.version)) {
                return 0;
            }
            String[] thisParts = this.version.split("\\.");
            String[] thatParts = that.version.split("\\.");
            int length = Math.max(thisParts.length, thatParts.length);
            for (int i = 0; i < length; ++i) {
                int thatPart;
                int thisPart = i < thisParts.length ? Integer.parseInt(thisParts[i]) : 0;
                int n = thatPart = i < thatParts.length ? Integer.parseInt(thatParts[i]) : 0;
                if (this.snapshot && i >= thisParts.length) {
                    thisPart = Integer.MAX_VALUE;
                }
                if (that.snapshot && i >= thatParts.length) {
                    thatPart = Integer.MAX_VALUE;
                }
                if (thisPart < thatPart) {
                    return -1;
                }
                if (thisPart <= thatPart) continue;
                return 1;
            }
            return this.snapshot == that.snapshot ? 0 : (this.snapshot ? 1 : -1);
        }

        public String toString() {
            return this.version + (this.snapshot ? "-SNAPSHOT" : "");
        }

        public int hashCode() {
            return this.toString().hashCode();
        }

        public boolean equals(Object that) {
            return this == that || that != null && this.getClass() == that.getClass() && this.compareTo((Version)that) == 0;
        }

        boolean newerThan(Version other) {
            return this.compareTo(other) > 0;
        }
    }
}

