/*
 * Decompiled with CFR 0.152.
 */
package me.nallar.mixin.internal;

import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import me.nallar.javatransformer.api.Annotation;
import me.nallar.javatransformer.api.ClassInfo;
import me.nallar.javatransformer.api.ClassMember;
import me.nallar.javatransformer.api.FieldInfo;
import me.nallar.javatransformer.api.JavaTransformer;
import me.nallar.javatransformer.api.MethodInfo;
import me.nallar.javatransformer.api.Transformer;
import me.nallar.mixin.internal.MixinError;
import me.nallar.whocalled.WhoCalled;

public class MixinApplicator {
    private static final Map<String, List<SortableAnnotationApplier<? extends ClassMember>>> consumerMap = new HashMap<String, List<SortableAnnotationApplier<? extends ClassMember>>>();
    private static final Map<Path, List<String>> sources = new HashMap<Path, List<String>>();
    private final List<TargetedTransformer> transformers = new ArrayList<TargetedTransformer>();
    private Consumer<String> log = System.out::println;
    private boolean makeAccessible = true;
    private boolean noMixinIsError = false;
    private boolean notAppliedIsError = true;
    private JavaTransformer transformer;

    private static void addAnnotationHandler(AnnotationApplier<?> applier, String ... names) {
        if (names.length == 0) {
            throw new IllegalArgumentException("Must provide at least one name");
        }
        for (String name : names) {
            if (!name.contains(".")) {
                name = "me.nallar.mixin." + name;
            }
            MixinApplicator.addAnnotationHandler(applier, name);
        }
    }

    private static void addAnnotationHandler(AnnotationApplier<?> applier, String name) {
        List appliers = consumerMap.computeIfAbsent(name, k -> new ArrayList());
        appliers.add(applier instanceof SortableAnnotationApplier ? (SortableAnnotationApplier<?>)applier : SortableAnnotationApplier.of(0, applier));
    }

    private static <T extends ClassMember> void addAnnotationHandler(Class<T> clazz, AnnotationApplier<T> specificApplier, String ... names) {
        int index = specificApplier instanceof SortableAnnotationApplier ? ((SortableAnnotationApplier)specificApplier).getSortIndex() : 0;
        SortableAnnotationApplier<ClassMember> applier = SortableAnnotationApplier.of(index, (applicator, annotation, annotated, target) -> {
            if (clazz.isAssignableFrom(annotated.getClass())) {
                specificApplier.apply(applicator, annotation, annotated, target);
            }
        });
        MixinApplicator.addAnnotationHandler(applier, names);
    }

    private static boolean packageNameMatches(String className, List<String> packages) {
        for (String s : packages) {
            if (s != null && !className.startsWith(s)) continue;
            return true;
        }
        return false;
    }

    private void logInfo(String s) {
        this.log.accept(s);
    }

    private static String ignoreException(Supplier<String> supplier, String name) {
        try {
            return supplier.get();
        }
        catch (Throwable t) {
            return "Failed to get '" + name + "' due to " + t;
        }
    }

    private Stream<SortableConsumer<ClassInfo>> handleAnnotation(ClassMember annotated) {
        return annotated.getAnnotations().stream().flatMap(annotation -> {
            List<SortableAnnotationApplier<? extends ClassMember>> appliers = consumerMap.get(annotation.type.getClassName());
            if (appliers == null) {
                return null;
            }
            return appliers.stream().map(applier -> SortableConsumer.of(applier.getSortIndex(), target -> {
                try {
                    applier.apply(this, (Annotation)annotation, annotated, (ClassInfo)target);
                }
                catch (Exception e) {
                    throw new MixinError("Failed to apply handler for annotation '" + annotation.type.getClassName() + "' on '" + MixinApplicator.ignoreException(annotated::toString, "annotated") + "' in '" + annotated.getClassInfo().getName() + "' to '" + target.getName() + "'", e);
                }
            }));
        }).filter(Objects::nonNull);
    }

    public void addSource(String mixinPackage) {
        try {
            this.addSource(Class.forName(mixinPackage + ".package-info", true, WhoCalled.$.getCallingClass().getClassLoader()));
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException(e);
        }
    }

    public void addSource(Class<?> mixinSource) {
        this.addSource(JavaTransformer.pathFromClass(mixinSource), mixinSource.getPackage().getName());
    }

    public void addSource(Path mixinSource) {
        this.addSource(mixinSource, null);
    }

    public void addSource(Path mixinSource, String packageName) {
        List<String> current = sources.get(mixinSource);
        if (current == null) {
            current = new ArrayList<String>();
            sources.put(mixinSource, current);
        }
        if (current.contains(null)) {
            return;
        }
        if (packageName == null) {
            current.clear();
        }
        current.add(packageName);
        this.transformer = null;
    }

    public JavaTransformer getMixinTransformer() {
        JavaTransformer transformer = this.transformer;
        if (transformer != null) {
            return transformer;
        }
        ArrayList<Transformer.TargetedTransformer> transformers = new ArrayList<Transformer.TargetedTransformer>();
        for (Map.Entry<Path, List<String>> pathListEntry : sources.entrySet()) {
            transformer = new JavaTransformer();
            transformer.addTransformer(classInfo -> {
                if (MixinApplicator.packageNameMatches(classInfo.getName(), (List)pathListEntry.getValue())) {
                    Optional.ofNullable(this.processMixinSource(classInfo)).ifPresent(transformers::add);
                }
            });
            transformer.parse(pathListEntry.getKey());
        }
        transformer = new JavaTransformer();
        transformers.forEach(transformer::addTransformer);
        if (this.notAppliedIsError) {
            transformer.getAfterTransform().add(this::checkForSkippedTransformers);
        }
        this.transformer = transformer;
        return this.transformer;
    }

    public void setLog(Consumer<String> log) {
        this.log.accept("Unregistering logger " + this.log + ", registering " + log);
        this.log = log;
    }

    private void checkForSkippedTransformers(JavaTransformer javaTransformer) {
        HashSet notRan = this.transformers.stream().filter(targetedTransformer -> !targetedTransformer.ran).collect(Collectors.toCollection(HashSet::new));
        if (!notRan.isEmpty()) {
            throw new MixinError(notRan.size() + " Transformers were not applied: " + this.transformers);
        }
    }

    private Transformer.TargetedTransformer processMixinSource(ClassInfo clazz) {
        List<Annotation> mixins = clazz.getAnnotations("me.nallar.mixin.Mixin");
        if (mixins.size() == 0) {
            if (this.noMixinIsError) {
                throw new RuntimeException("Class " + clazz.getName() + " is not an @Mixin");
            }
            return null;
        }
        if (mixins.size() > 1) {
            throw new MixinError(clazz.getName() + " can not use @Mixin multiple times");
        }
        Annotation mixin = mixins.get(0);
        String target = (String)mixin.values.get("target");
        if (target == null || target.isEmpty()) {
            target = clazz.getSuperType().getClassName();
        }
        if (!clazz.getAccessFlags().has(1024)) {
            throw new MixinError(clazz.getName() + " must be abstract to use @Mixin");
        }
        final List applicators = Stream.concat(Stream.of(clazz), clazz.getMembers().stream()).flatMap(this::handleAnnotation).sorted().collect(Collectors.toList());
        this.logInfo("Found Mixin class '" + clazz.getName() + "' targeting class '" + target + " with " + applicators.size() + " applicators.");
        assert (!applicators.isEmpty());
        final String finalTarget = target;
        TargetedTransformer transformer = new TargetedTransformer(){

            @Override
            public Collection<String> getTargetClasses() {
                return Collections.singletonList(finalTarget);
            }

            @Override
            public void transform(ClassInfo classInfo) {
                this.ran = true;
                applicators.forEach(applicator -> applicator.accept(classInfo));
            }
        };
        this.transformers.add(transformer);
        return transformer;
    }

    public List<TargetedTransformer> getTransformers() {
        return this.transformers;
    }

    public Consumer<String> getLog() {
        return this.log;
    }

    public boolean isMakeAccessible() {
        return this.makeAccessible;
    }

    public boolean isNoMixinIsError() {
        return this.noMixinIsError;
    }

    public boolean isNotAppliedIsError() {
        return this.notAppliedIsError;
    }

    public void setMakeAccessible(boolean makeAccessible) {
        this.makeAccessible = makeAccessible;
    }

    public void setNoMixinIsError(boolean noMixinIsError) {
        this.noMixinIsError = noMixinIsError;
    }

    public void setNotAppliedIsError(boolean notAppliedIsError) {
        this.notAppliedIsError = notAppliedIsError;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof MixinApplicator)) {
            return false;
        }
        MixinApplicator other = (MixinApplicator)o;
        if (!other.canEqual(this)) {
            return false;
        }
        List<TargetedTransformer> this$transformers = this.getTransformers();
        List<TargetedTransformer> other$transformers = other.getTransformers();
        if (this$transformers == null ? other$transformers != null : !((Object)this$transformers).equals(other$transformers)) {
            return false;
        }
        Consumer<String> this$log = this.getLog();
        Consumer<String> other$log = other.getLog();
        if (this$log == null ? other$log != null : !this$log.equals(other$log)) {
            return false;
        }
        if (this.isMakeAccessible() != other.isMakeAccessible()) {
            return false;
        }
        if (this.isNoMixinIsError() != other.isNoMixinIsError()) {
            return false;
        }
        if (this.isNotAppliedIsError() != other.isNotAppliedIsError()) {
            return false;
        }
        JavaTransformer this$transformer = this.transformer;
        JavaTransformer other$transformer = other.transformer;
        return !(this$transformer == null ? other$transformer != null : !this$transformer.equals(other$transformer));
    }

    protected boolean canEqual(Object other) {
        return other instanceof MixinApplicator;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        List<TargetedTransformer> $transformers = this.getTransformers();
        result = result * 59 + ($transformers == null ? 0 : ((Object)$transformers).hashCode());
        Consumer<String> $log = this.getLog();
        result = result * 59 + ($log == null ? 0 : $log.hashCode());
        result = result * 59 + (this.isMakeAccessible() ? 79 : 97);
        result = result * 59 + (this.isNoMixinIsError() ? 79 : 97);
        result = result * 59 + (this.isNotAppliedIsError() ? 79 : 97);
        JavaTransformer $transformer = this.transformer;
        result = result * 59 + ($transformer == null ? 0 : $transformer.hashCode());
        return result;
    }

    public String toString() {
        return "MixinApplicator(transformers=" + this.getTransformers() + ", log=" + this.getLog() + ", makeAccessible=" + this.isMakeAccessible() + ", noMixinIsError=" + this.isNoMixinIsError() + ", notAppliedIsError=" + this.isNotAppliedIsError() + ", transformer=" + this.transformer + ")";
    }

    static {
        MixinApplicator.addAnnotationHandler(ClassInfo.class, SortableAnnotationApplier.of(-1, (applicator, annotation, member, target) -> applicator.logInfo("Handling class " + member.getName() + " with annotation " + annotation)), "Mixin");
        MixinApplicator.addAnnotationHandler(ClassInfo.class, SortableAnnotationApplier.of(1, (applicator, annotation, member, target) -> {
            if (!applicator.makeAccessible) {
                return;
            }
            Object makePublicObject = annotation.values.get("makePublic");
            boolean makePublic = makePublicObject != null && (Boolean)makePublicObject != false;
            target.accessFlags(f -> f.makeAccessible(makePublic).without(16));
            target.getMembers().forEach(it -> it.accessFlags(f -> f.makeAccessible(makePublic).without(16)));
        }), "Mixin");
        MixinApplicator.addAnnotationHandler(FieldInfo.class, (MixinApplicator applicator, Annotation annotation, T member, ClassInfo target) -> {
            String name = member.getName();
            if (!name.endsWith("_")) {
                throw new MixinError("Name of @Add-ed field must end with '_'");
            }
            target.add((FieldInfo)member);
            target.get((FieldInfo)member).setName(name.substring(0, name.length() - 1));
        }, "Add");
        MixinApplicator.addAnnotationHandler(MethodInfo.class, (MixinApplicator applicator, Annotation annotation, T member, ClassInfo target) -> target.add((MethodInfo)member), "Add");
        MixinApplicator.addAnnotationHandler(MethodInfo.class, (MixinApplicator applicator, Annotation annotation, T member, ClassInfo target) -> {
            MethodInfo existing = target.get((MethodInfo)member);
            if (existing == null) {
                throw new MixinError("Can't override method " + member + " as it does not exist in target: " + target + "\nMethods in target: " + target.getMethods());
            }
            target.remove(existing);
            target.add((MethodInfo)member);
        }, "java.lang.Override", "OverrideStatic");
    }

    private static abstract class TargetedTransformer
    implements Transformer.TargetedTransformer {
        boolean ran;

        private TargetedTransformer() {
        }

        public String toString() {
            Collection<String> classes = this.getTargetClasses();
            return classes.size() == 1 ? classes.iterator().next() : classes.toString();
        }
    }

    private static interface SortableConsumer<T>
    extends Consumer<T>,
    Comparable {
        public static <T> SortableConsumer<T> of(final int sortIndex, final Consumer<T> consumer) {
            return new SortableConsumer<T>(){

                @Override
                public int getSortIndex() {
                    return sortIndex;
                }

                @Override
                public void accept(T t) {
                    consumer.accept(t);
                }
            };
        }

        public int getSortIndex();

        default public int compareTo(Object other) {
            return Integer.compare(this.getSortIndex(), ((SortableConsumer)other).getSortIndex());
        }
    }

    private static interface SortableAnnotationApplier<T extends ClassMember>
    extends AnnotationApplier<T> {
        public static <T extends ClassMember> SortableAnnotationApplier<T> of(final int index, final AnnotationApplier<T> applier) {
            return new SortableAnnotationApplier<T>(){

                @Override
                public int getSortIndex() {
                    return index;
                }

                @Override
                public void apply(MixinApplicator applicator, Annotation annotation, T annotatedMember, ClassInfo mixinTarget) {
                    applier.apply(applicator, annotation, annotatedMember, mixinTarget);
                }
            };
        }

        public int getSortIndex();
    }

    private static interface AnnotationApplier<T extends ClassMember> {
        public void apply(MixinApplicator var1, Annotation var2, T var3, ClassInfo var4);
    }
}

