/*
 * Decompiled with CFR 0.152.
 */
package me.nallar.javatransformer.internal.util;

import com.github.javaparser.ast.Node;
import com.github.javaparser.ast.TypeParameter;
import com.github.javaparser.ast.body.ClassOrInterfaceDeclaration;
import com.github.javaparser.ast.body.MethodDeclaration;
import com.github.javaparser.ast.expr.NameExpr;
import com.github.javaparser.ast.expr.QualifiedNameExpr;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Function;

public final class NodeUtil {
    public static void forChildren(Node node, Consumer<Node> nodeConsumer) {
        NodeUtil.forChildren(node, nodeConsumer, Node.class);
    }

    public static <T> void forChildren(Node node, Consumer<T> nodeConsumer, Class<T> ofClass) {
        for (Node child : node.getChildrenNodes()) {
            if (ofClass.isAssignableFrom(child.getClass())) {
                nodeConsumer.accept(child);
            }
            NodeUtil.forChildren(child, nodeConsumer, ofClass);
        }
    }

    public static <ResultType> List<ResultType> getFromList(Node node, Function<Node, List<ResultType>> getter) {
        ArrayList<ResultType> parameters = new ArrayList<ResultType>();
        while (node != null) {
            List<ResultType> extra = getter.apply(node);
            if (extra != null && !extra.isEmpty()) {
                parameters.addAll(extra);
            }
            node = node.getParentNode();
        }
        return parameters;
    }

    public static <ResultType> List<ResultType> getFromSingle(Node node, Function<Node, ResultType> getter) {
        ArrayList<ResultType> parameters = null;
        while (node != null) {
            ResultType extra = getter.apply(node);
            if (extra != null) {
                if (parameters == null) {
                    parameters = new ArrayList<ResultType>();
                }
                parameters.add(extra);
            }
            node = node.getParentNode();
        }
        return parameters;
    }

    public static List<TypeParameter> getTypeParameters(Node node) {
        return NodeUtil.getFromList(node, NodeUtil::getTypeParametersOnly);
    }

    private static List<TypeParameter> getTypeParametersOnly(Node node) {
        if (node instanceof ClassOrInterfaceDeclaration) {
            return ((ClassOrInterfaceDeclaration)node).getTypeParameters();
        }
        if (node instanceof MethodDeclaration) {
            return ((MethodDeclaration)node).getTypeParameters();
        }
        return null;
    }

    public static <T extends Node> T getParentNode(Node node, Class<T> target) {
        while ((node = node.getParentNode()) != null && !target.isAssignableFrom(node.getClass())) {
        }
        return (T)node;
    }

    static void qualifiedName(NameExpr nameExpr, StringBuilder builder) {
        if (nameExpr instanceof QualifiedNameExpr) {
            NodeUtil.qualifiedName(((QualifiedNameExpr)nameExpr).getQualifier(), builder);
            builder.append('.');
        }
        builder.append(nameExpr.getName());
    }

    public static String qualifiedName(NameExpr nameExpr) {
        StringBuilder sb = new StringBuilder();
        NodeUtil.qualifiedName(nameExpr, sb);
        return sb.toString();
    }

    private NodeUtil() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

