/*
 * Decompiled with CFR 0.152.
 */
package me.nallar.javatransformer.internal.util;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import me.nallar.javatransformer.api.TransformationException;
import me.nallar.javatransformer.internal.util.Joiner;
import me.nallar.javatransformer.internal.util.Splitter;

public final class JVMUtil {
    private static final Splitter dotSplitter = Splitter.on('.');

    public static String getDescriptor(Class<?> clazz) {
        if (clazz.isPrimitive()) {
            return JVMUtil.descriptorToPrimitiveType(clazz.getSimpleName());
        }
        return 'L' + clazz.getCanonicalName() + ';';
    }

    public static String descriptorToPrimitiveType(String descriptor) {
        switch (descriptor) {
            case "B": {
                return "byte";
            }
            case "C": {
                return "char";
            }
            case "D": {
                return "double";
            }
            case "F": {
                return "float";
            }
            case "I": {
                return "int";
            }
            case "J": {
                return "long";
            }
            case "S": {
                return "short";
            }
            case "V": {
                return "void";
            }
            case "Z": {
                return "boolean";
            }
        }
        throw new TransformationException("Invalid descriptor: " + descriptor);
    }

    public static String primitiveTypeToDescriptor(String primitive) {
        return JVMUtil.primitiveTypeToDescriptor(primitive, false);
    }

    public static String primitiveTypeToDescriptor(String primitive, boolean allowMissing) {
        switch (primitive) {
            case "byte": {
                return "B";
            }
            case "char": {
                return "C";
            }
            case "double": {
                return "D";
            }
            case "float": {
                return "F";
            }
            case "int": {
                return "I";
            }
            case "long": {
                return "J";
            }
            case "short": {
                return "S";
            }
            case "void": {
                return "V";
            }
            case "boolean": {
                return "Z";
            }
        }
        if (allowMissing) {
            return null;
        }
        throw new TransformationException("Invalid primitive type: " + primitive);
    }

    public static <T extends Enum<?>> T searchEnum(Class<T> enumeration, String search) {
        for (Enum each : (Enum[])enumeration.getEnumConstants()) {
            if (!each.name().equalsIgnoreCase(search)) continue;
            return (T)each;
        }
        return null;
    }

    public static String getParameterList(Method m) {
        ArrayList parameterClasses = new ArrayList(Arrays.asList(m.getParameterTypes()));
        StringBuilder parameters = new StringBuilder();
        for (Class clazz : parameterClasses) {
            parameters.append(JVMUtil.getDescriptor(clazz));
        }
        return parameters.toString();
    }

    public static String accessIntToString(int access) {
        StringBuilder result = new StringBuilder();
        if (JVMUtil.hasFlag(access, 1)) {
            result.append(" public");
        }
        if (JVMUtil.hasFlag(access, 2)) {
            result.append(" private");
        }
        if (JVMUtil.hasFlag(access, 4)) {
            result.append(" protected");
        }
        if (JVMUtil.hasFlag(access, 8)) {
            result.append(" static");
        }
        if (JVMUtil.hasFlag(access, 16)) {
            result.append(" final");
        }
        return result.toString().trim();
    }

    public static int accessStringToInt(String access) {
        int a = 0;
        Iterator<String> iterator = Splitter.on(' ').splitIterable(access).iterator();
        block14: while (iterator.hasNext()) {
            String accessPart;
            switch (accessPart = iterator.next()) {
                case "public": {
                    a |= 1;
                    continue block14;
                }
                case "protected": {
                    a |= 4;
                    continue block14;
                }
                case "private": {
                    a |= 2;
                    continue block14;
                }
                case "static": {
                    a |= 8;
                    continue block14;
                }
                case "synthetic": {
                    a |= 0x1000;
                    continue block14;
                }
            }
            throw new TransformationException("Unknown access string " + access);
        }
        return a;
    }

    public static String fileNameToClassName(String f) {
        f = JVMUtil.removeFromEnd(f, ".class");
        f = JVMUtil.removeFromEnd(f, ".java");
        return f.replace('\\', '.').replace('/', '.');
    }

    private static String removeFromEnd(String s, String f) {
        return s.endsWith(f) ? s.substring(0, s.length() - f.length()) : s;
    }

    public static boolean hasFlag(int access, int flag) {
        return (access & flag) != 0;
    }

    public static int replaceFlag(int in, int from, int to) {
        if ((in & from) != 0) {
            in &= ~from;
            in |= to;
        }
        return in;
    }

    public static int makeAccess(int access, boolean makePublic) {
        access = JVMUtil.makeAtLeastProtected(access);
        if (makePublic) {
            access = JVMUtil.replaceFlag(access, 4, 1);
        }
        return access;
    }

    public static int makeAtLeastProtected(int access) {
        if (JVMUtil.hasFlag(access, 1) || JVMUtil.hasFlag(access, 4)) {
            return access;
        }
        if (JVMUtil.hasFlag(access, 2)) {
            return JVMUtil.replaceFlag(access, 2, 4);
        }
        return access | 1;
    }

    public static String classNameToJLSName(String className) {
        int i;
        ArrayList<String> parts = new ArrayList<String>();
        dotSplitter.splitIterable(className).forEach(parts::add);
        boolean possibleClass = true;
        int size = i = parts.size() - 1;
        while (i >= 0) {
            boolean last;
            String part = (String)parts.get(i);
            boolean bl = last = i == size;
            if (!last && !Character.isUpperCase(part.charAt(0))) {
                possibleClass = false;
            }
            if (!last) {
                parts.set(i, part + (possibleClass ? (char)'$' : '/'));
            }
            --i;
        }
        return Joiner.on().join(parts);
    }

    private JVMUtil() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

