/*
 * Decompiled with CFR 0.152.
 */
package me.nallar.javatransformer.internal.util;

import com.github.javaparser.ast.expr.AnnotationExpr;
import com.github.javaparser.ast.expr.BooleanLiteralExpr;
import com.github.javaparser.ast.expr.Expression;
import com.github.javaparser.ast.expr.MarkerAnnotationExpr;
import com.github.javaparser.ast.expr.MemberValuePair;
import com.github.javaparser.ast.expr.NormalAnnotationExpr;
import com.github.javaparser.ast.expr.SingleMemberAnnotationExpr;
import com.github.javaparser.ast.expr.StringLiteralExpr;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import me.nallar.javatransformer.api.Annotation;
import me.nallar.javatransformer.api.TransformationException;
import me.nallar.javatransformer.api.Type;
import me.nallar.javatransformer.internal.ResolutionContext;
import me.nallar.javatransformer.internal.util.NodeUtil;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.tree.AnnotationNode;

public final class AnnotationParser {
    public static List<Annotation> parseAnnotations(byte[] bytes) {
        ClassReader cr = new ClassReader(bytes);
        AnnotationVisitor cv = new AnnotationVisitor();
        cr.accept((ClassVisitor)cv, 7);
        return cv.annotations.stream().map(AnnotationParser::annotationFromAnnotationNode).collect(Collectors.toList());
    }

    public static Annotation annotationFromAnnotationNode(AnnotationNode annotationNode) {
        return Annotation.of(new Type(annotationNode.desc), AnnotationParser.getAnnotationNodeValues(annotationNode));
    }

    private static Map<String, Object> getAnnotationNodeValues(AnnotationNode annotationNode) {
        if (annotationNode.values == null) {
            return Collections.emptyMap();
        }
        HashMap<String, Object> values = new HashMap<String, Object>();
        for (int i = 0; i < annotationNode.values.size(); i += 2) {
            values.put((String)annotationNode.values.get(i), annotationNode.values.get(i + 1));
        }
        return values;
    }

    public static Annotation annotationFromAnnotationExpr(AnnotationExpr annotationExpr) {
        Type t = ResolutionContext.of(annotationExpr).resolve(NodeUtil.qualifiedName(annotationExpr.getName()));
        if (annotationExpr instanceof SingleMemberAnnotationExpr) {
            return Annotation.of(t, AnnotationParser.expressionToValue(((SingleMemberAnnotationExpr)annotationExpr).getMemberValue()));
        }
        if (annotationExpr instanceof NormalAnnotationExpr) {
            HashMap<String, Object> map = new HashMap<String, Object>();
            for (MemberValuePair memberValuePair : ((NormalAnnotationExpr)annotationExpr).getPairs()) {
                map.put(memberValuePair.getName(), AnnotationParser.expressionToValue(memberValuePair.getValue()));
            }
            return Annotation.of(t, map);
        }
        if (annotationExpr instanceof MarkerAnnotationExpr) {
            return Annotation.of(t);
        }
        throw new TransformationException("Unknown annotation type: " + annotationExpr.getClass().getCanonicalName());
    }

    private static Object expressionToValue(Expression e) {
        if (e instanceof StringLiteralExpr) {
            return ((StringLiteralExpr)e).getValue();
        }
        if (e instanceof BooleanLiteralExpr) {
            return ((BooleanLiteralExpr)e).getValue();
        }
        throw new TransformationException("Unknown value: " + e);
    }

    private AnnotationParser() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }

    private static class AnnotationVisitor
    extends ClassVisitor {
        public final List<AnnotationNode> annotations = new ArrayList<AnnotationNode>();

        public AnnotationVisitor() {
            super(327680);
        }

        public org.objectweb.asm.AnnotationVisitor visitAnnotation(String desc, boolean visible) {
            AnnotationNode an = new AnnotationNode(desc);
            this.annotations.add(an);
            return an;
        }
    }
}

