/*
 * Decompiled with CFR 0.152.
 */
package me.nallar.javatransformer.internal;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import me.nallar.javatransformer.api.AccessFlags;
import me.nallar.javatransformer.api.Annotation;
import me.nallar.javatransformer.api.ClassInfo;
import me.nallar.javatransformer.api.MethodInfo;
import me.nallar.javatransformer.api.Parameter;
import me.nallar.javatransformer.api.Type;
import me.nallar.javatransformer.api.TypeVariable;

public class SimpleMethodInfo
implements MethodInfo {
    public AccessFlags accessFlags;
    public List<TypeVariable> typeVariables;
    public Type returnType;
    public String name;
    public List<Parameter> parameters;
    public List<Annotation> annotations;

    private SimpleMethodInfo(AccessFlags accessFlags, List<TypeVariable> typeVariables, Type returnType, String name, List<Parameter> parameters) {
        this.accessFlags = accessFlags;
        this.typeVariables = new ArrayList<TypeVariable>(typeVariables);
        this.returnType = returnType;
        this.name = name;
        this.parameters = new ArrayList<Parameter>(parameters);
    }

    public static MethodInfo of(AccessFlags accessFlags, List<TypeVariable> typeVariables, Type returnType, String name, List<Parameter> parameters) {
        return new SimpleMethodInfo(accessFlags, typeVariables, returnType, name, parameters);
    }

    public static String toString(MethodInfo info) {
        return info.getAccessFlags().toString() + ' ' + info.getReturnType() + ' ' + info.getName() + '(' + info.getParameters() + ')';
    }

    @Override
    public List<Parameter> getParameters() {
        return Collections.unmodifiableList(this.parameters);
    }

    @Override
    public ClassInfo getClassInfo() {
        return null;
    }

    public String toString() {
        return SimpleMethodInfo.toString(this);
    }

    @Override
    public MethodInfo clone() {
        return SimpleMethodInfo.of(this.accessFlags, this.typeVariables, this.returnType, this.name, this.parameters);
    }

    @Override
    public AccessFlags getAccessFlags() {
        return this.accessFlags;
    }

    @Override
    public List<TypeVariable> getTypeVariables() {
        return this.typeVariables;
    }

    @Override
    public Type getReturnType() {
        return this.returnType;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public List<Annotation> getAnnotations() {
        return this.annotations;
    }

    @Override
    public void setAccessFlags(AccessFlags accessFlags) {
        this.accessFlags = accessFlags;
    }

    @Override
    public void setTypeVariables(List<TypeVariable> typeVariables) {
        this.typeVariables = typeVariables;
    }

    @Override
    public void setReturnType(Type returnType) {
        this.returnType = returnType;
    }

    @Override
    public void setName(String name) {
        this.name = name;
    }

    @Override
    public void setParameters(List<Parameter> parameters) {
        this.parameters = parameters;
    }

    public void setAnnotations(List<Annotation> annotations) {
        this.annotations = annotations;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof SimpleMethodInfo)) {
            return false;
        }
        SimpleMethodInfo other = (SimpleMethodInfo)o;
        if (!other.canEqual(this)) {
            return false;
        }
        AccessFlags this$accessFlags = this.getAccessFlags();
        AccessFlags other$accessFlags = other.getAccessFlags();
        if (this$accessFlags == null ? other$accessFlags != null : !((Object)this$accessFlags).equals(other$accessFlags)) {
            return false;
        }
        List<TypeVariable> this$typeVariables = this.getTypeVariables();
        List<TypeVariable> other$typeVariables = other.getTypeVariables();
        if (this$typeVariables == null ? other$typeVariables != null : !((Object)this$typeVariables).equals(other$typeVariables)) {
            return false;
        }
        Type this$returnType = this.getReturnType();
        Type other$returnType = other.getReturnType();
        if (this$returnType == null ? other$returnType != null : !((Object)this$returnType).equals(other$returnType)) {
            return false;
        }
        String this$name = this.getName();
        String other$name = other.getName();
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
            return false;
        }
        List<Parameter> this$parameters = this.getParameters();
        List<Parameter> other$parameters = other.getParameters();
        if (this$parameters == null ? other$parameters != null : !((Object)this$parameters).equals(other$parameters)) {
            return false;
        }
        List<Annotation> this$annotations = this.getAnnotations();
        List<Annotation> other$annotations = other.getAnnotations();
        return !(this$annotations == null ? other$annotations != null : !((Object)this$annotations).equals(other$annotations));
    }

    protected boolean canEqual(Object other) {
        return other instanceof SimpleMethodInfo;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        AccessFlags $accessFlags = this.getAccessFlags();
        result = result * 59 + ($accessFlags == null ? 0 : ((Object)$accessFlags).hashCode());
        List<TypeVariable> $typeVariables = this.getTypeVariables();
        result = result * 59 + ($typeVariables == null ? 0 : ((Object)$typeVariables).hashCode());
        Type $returnType = this.getReturnType();
        result = result * 59 + ($returnType == null ? 0 : ((Object)$returnType).hashCode());
        String $name = this.getName();
        result = result * 59 + ($name == null ? 0 : $name.hashCode());
        List<Parameter> $parameters = this.getParameters();
        result = result * 59 + ($parameters == null ? 0 : ((Object)$parameters).hashCode());
        List<Annotation> $annotations = this.getAnnotations();
        result = result * 59 + ($annotations == null ? 0 : ((Object)$annotations).hashCode());
        return result;
    }
}

