/*
 * Decompiled with CFR 0.152.
 */
package me.nallar.javatransformer.api;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.function.Function;
import java.util.stream.Collectors;
import lombok.NonNull;
import me.nallar.javatransformer.api.TransformationException;
import me.nallar.javatransformer.internal.ResolutionContext;
import me.nallar.javatransformer.internal.util.CollectionUtil;
import me.nallar.javatransformer.internal.util.JVMUtil;
import me.nallar.javatransformer.internal.util.Joiner;
import me.nallar.javatransformer.internal.util.Splitter;
import me.nallar.javatransformer.internal.util.TypeUtil;
import org.jetbrains.annotations.Nullable;

public class Type {
    public static final Type UNKNOWN = new Type("Ljava/lang/Object;", "Tunknown;");
    public static final Type OBJECT = Type.of("java.lang.Object");
    @NonNull
    public final String descriptor;
    @Nullable
    public final String signature;

    public Type(String descriptor, @Nullable String signature) {
        if (descriptor.isEmpty()) {
            throw new IllegalArgumentException("descriptor");
        }
        if (signature != null && (signature.isEmpty() || signature.equals(descriptor))) {
            signature = null;
        }
        Type.checkDescriptor(descriptor);
        Type.checkSignature(signature);
        this.descriptor = descriptor;
        this.signature = signature;
    }

    public Type(String descriptor) {
        this(descriptor, null);
    }

    private static void checkDescriptor(String descriptor) {
        if (descriptor.charAt(0) == 'T') {
            throw new TransformationException("Invalid descriptor '" + descriptor + "'");
        }
    }

    private static void checkSignature(String signature) {
        if (signature == null) {
            return;
        }
        int lastBracket = signature.lastIndexOf(62);
        if (lastBracket == -1) {
            return;
        }
        char after = signature.charAt(lastBracket + 1);
        if (after != ';' && after != '>') {
            throw new TransformationException("Invalid signature '" + signature + "'. After generic bracket should either be '>' or ';'");
        }
    }

    public static Type of(String fullClassName) {
        String realType = ResolutionContext.extractReal(fullClassName);
        Type type = new Type('L' + JVMUtil.classNameToJLSName(realType) + ';');
        String genericType = ResolutionContext.extractGeneric(fullClassName);
        if (genericType == null) {
            return type;
        }
        return type.withTypeArguments(CollectionUtil.stream(Splitter.commaSplitter.splitIterable(genericType)).map(Type::of).collect(Collectors.toList()));
    }

    public static List<Type> listOf(String desc, String signature) {
        List<String> parsedDesc = TypeUtil.splitTypes(desc, false);
        List<String> parsedSignature = TypeUtil.splitTypes(signature, true);
        if (parsedSignature != null && parsedSignature.size() != parsedDesc.size()) {
            throw new TransformationException("Failed to parse type lists.\n\tdesc: " + desc + "\n\tsignature: " + signature + "\n\tparsedDesc: " + parsedDesc + "\n\tparsedSignature: " + parsedSignature);
        }
        ArrayList<Type> types = new ArrayList<Type>();
        for (int i = 0; i < parsedDesc.size(); ++i) {
            String real = parsedDesc.get(i);
            String generic = parsedSignature == null ? null : parsedSignature.get(i);
            types.add(new Type(real, generic));
        }
        return types;
    }

    public static Type ofSignature(String signature) {
        if (signature.charAt(0) == 'T') {
            return new Type("Ljava/lang/Object;", signature);
        }
        return new Type(ResolutionContext.extractReal(signature), signature);
    }

    public boolean isPrimitiveType() {
        char first = this.descriptor.charAt(0);
        return first != 'L' && first != 'T';
    }

    public boolean isClassType() {
        char first = this.descriptor.charAt(0);
        return first == 'L';
    }

    public boolean isTypeParameter() {
        String signature = this.signature;
        return signature != null && signature.charAt(0) == 'T';
    }

    public String getSimpleName() {
        if (this.isTypeParameter()) {
            return this.getTypeParameterName();
        }
        if (this.isPrimitiveType()) {
            return this.getPrimitiveTypeName();
        }
        if (this.isClassType()) {
            return this.getClassName() + (this.hasTypeArguments() ? "<" + Joiner.on(",").join(this.getTypeArguments().stream().map(Type::getSimpleName)) + ">" : "");
        }
        throw new IllegalStateException("Unknown type for type: " + this);
    }

    public String getPrimitiveTypeName() {
        if (!this.isPrimitiveType()) {
            throw new UnsupportedOperationException("Can't get classname for type: " + this);
        }
        return JVMUtil.descriptorToPrimitiveType(this.descriptorWithoutArray());
    }

    public String getClassName() {
        if (!this.isClassType()) {
            throw new UnsupportedOperationException("Can't get classname for type: " + this);
        }
        return this.descriptorWithoutArray().substring(1, this.descriptor.length() - 1).replace('/', '.');
    }

    public String getTypeParameterName() {
        if (this.signature == null || !this.isTypeParameter()) {
            throw new UnsupportedOperationException("Can't get type parameter name for type: " + this);
        }
        return this.signature.substring(1, this.signature.length() - 1);
    }

    public Type remapClassNames(Function<String, String> mapper) {
        if (!this.isClassType()) {
            return new Type(this.descriptor, this.signature);
        }
        Type mappedType = Type.of(mapper.apply(this.getClassName()));
        if (this.isTypeParameter()) {
            mappedType = new Type(mappedType.descriptor, this.signature);
        }
        if (this.hasTypeArguments()) {
            mappedType = mappedType.withTypeArguments(this.getTypeArguments().stream().map(it -> it.remapClassNames(mapper)).collect(Collectors.toList()));
        }
        return mappedType;
    }

    public boolean hasTypeArguments() {
        return this.signature != null && this.signature.indexOf(60) != -1;
    }

    public List<Type> getTypeArguments() {
        if (this.signature == null || !this.hasTypeArguments()) {
            throw new UnsupportedOperationException("Can't get type argument for type: " + this);
        }
        String arguments = ResolutionContext.extractGeneric(this.signature);
        ArrayList<Type> argumentList = new ArrayList<Type>();
        for (String argument : CollectionUtil.iterable(TypeUtil.readTypes(arguments, true))) {
            argumentList.add(Type.ofSignature(argument));
        }
        assert (!argumentList.isEmpty());
        return argumentList;
    }

    public String signatureElseDescriptor() {
        return this.signature == null ? this.descriptor : this.signature;
    }

    public String descriptorWithoutArray() {
        return this.descriptor.substring(this.descriptor.lastIndexOf(91) + 1);
    }

    public Type withTypeArgument(Type of) {
        return this.withTypeArguments(Collections.singletonList(of));
    }

    public Type withTypeArguments(Iterable<Type> genericType) {
        if (this.isPrimitiveType()) {
            throw new UnsupportedOperationException("Can not add type argument to primitive type");
        }
        String signature = this.signatureElseDescriptor();
        int semicolon = signature.lastIndexOf(59);
        if (semicolon == -1) {
            throw new IllegalStateException("Couldn't find ';' in: " + this);
        }
        StringBuilder sb = new StringBuilder(signature);
        sb.insert(semicolon, '<' + Joiner.on().join(CollectionUtil.stream(genericType).map(Type::signatureElseDescriptor)) + '>');
        return new Type(this.descriptor, sb.toString());
    }

    public boolean similar(@NonNull Type other) {
        if (other == null) {
            throw new NullPointerException("other");
        }
        return UNKNOWN == this || UNKNOWN == other || this.descriptor.equals(other.descriptor);
    }

    public String toString() {
        return "Type(descriptor=" + this.descriptor + ", signature=" + this.signature + ", simpleName=" + this.getSimpleName() + ")";
    }

    public Type withArrayCount(int arrayCount) {
        if (arrayCount == 0) {
            return this;
        }
        char[] brackets = new char[arrayCount];
        Arrays.fill(brackets, '[');
        return new Type(new String(brackets) + this.descriptor, this.signature);
    }

    public Type withClassName(String name) {
        String descriptor = "L" + name.replace('.', '/') + ";";
        String signature = this.signature;
        if (signature != null) {
            signature = descriptor + signature.substring(signature.indexOf(59) + 1);
        }
        return new Type(descriptor, signature);
    }

    @NonNull
    public String getDescriptor() {
        return this.descriptor;
    }

    @Nullable
    public String getSignature() {
        return this.signature;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Type)) {
            return false;
        }
        Type other = (Type)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$descriptor = this.getDescriptor();
        String other$descriptor = other.getDescriptor();
        if (this$descriptor == null ? other$descriptor != null : !this$descriptor.equals(other$descriptor)) {
            return false;
        }
        String this$signature = this.getSignature();
        String other$signature = other.getSignature();
        return !(this$signature == null ? other$signature != null : !this$signature.equals(other$signature));
    }

    protected boolean canEqual(Object other) {
        return other instanceof Type;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $descriptor = this.getDescriptor();
        result = result * 59 + ($descriptor == null ? 0 : $descriptor.hashCode());
        String $signature = this.getSignature();
        result = result * 59 + ($signature == null ? 0 : $signature.hashCode());
        return result;
    }
}

