/*
 * Decompiled with CFR 0.152.
 */
package me.nallar.javatransformer.api;

import com.github.javaparser.JavaParser;
import com.github.javaparser.ParseException;
import com.github.javaparser.ast.CompilationUnit;
import com.github.javaparser.ast.body.ClassOrInterfaceDeclaration;
import com.github.javaparser.ast.body.TypeDeclaration;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UncheckedIOException;
import java.net.MalformedURLException;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import java.util.function.Supplier;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;
import lombok.NonNull;
import me.nallar.javatransformer.api.ClassInfo;
import me.nallar.javatransformer.api.TransformationException;
import me.nallar.javatransformer.api.Transformer;
import me.nallar.javatransformer.internal.ByteCodeInfo;
import me.nallar.javatransformer.internal.SourceInfo;
import me.nallar.javatransformer.internal.util.CachingSupplier;
import me.nallar.javatransformer.internal.util.FilteringClassWriter;
import me.nallar.javatransformer.internal.util.JVMUtil;
import me.nallar.javatransformer.internal.util.NodeUtil;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.tree.ClassNode;

public class JavaTransformer {
    private final List<Transformer> transformers = new ArrayList<Transformer>();
    private final SimpleMultiMap<String, Transformer> classTransformers = new SimpleMultiMap();
    private final Map<String, byte[]> transformedFiles = new HashMap<String, byte[]>();
    private final List<Consumer<JavaTransformer>> afterTransform = new ArrayList<Consumer<JavaTransformer>>();

    private static byte[] readFully(InputStream is) {
        byte[] output = new byte[]{};
        int position = 0;
        while (true) {
            int bytesRead;
            int bytesToRead;
            if (position >= output.length) {
                bytesToRead = output.length + 4096;
                if (output.length < position + bytesToRead) {
                    output = Arrays.copyOf(output, position + bytesToRead);
                }
            } else {
                bytesToRead = output.length - position;
            }
            try {
                bytesRead = is.read(output, position, bytesToRead);
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
            if (bytesRead < 0) {
                if (output.length == position) break;
                output = Arrays.copyOf(output, position);
                break;
            }
            position += bytesRead;
        }
        return output;
    }

    public static Path pathFromClass(Class<?> clazz) {
        URL location;
        try {
            location = clazz.getProtectionDomain().getCodeSource().getLocation().toURI().toURL();
        }
        catch (MalformedURLException | URISyntaxException e) {
            throw new TransformationException(e);
        }
        try {
            if (location.getProtocol().equals("jar")) {
                String path = location.getPath();
                int bang = path.lastIndexOf(33);
                location = new URL(bang == -1 ? path : path.substring(0, bang));
            }
            return Paths.get(location.toURI());
        }
        catch (Exception e) {
            throw new TransformationException("Failed to get pathFromClass, location: " + location, e);
        }
    }

    public Map<String, List<Transformer>> getClassTransformers() {
        return Collections.unmodifiableMap(((SimpleMultiMap)this.classTransformers).map);
    }

    public void save(@NonNull Path path) {
        if (path == null) {
            throw new NullPointerException("path");
        }
        switch (PathType.of(path)) {
            case JAR: {
                this.saveJar(path);
                break;
            }
            case FOLDER: {
                this.saveFolder(path);
            }
        }
    }

    public void load(@NonNull Path path) {
        if (path == null) {
            throw new NullPointerException("path");
        }
        this.load(path, true);
    }

    public void parse(@NonNull Path path) {
        if (path == null) {
            throw new NullPointerException("path");
        }
        this.load(path, false);
    }

    private void load(@NonNull Path path, boolean saveTransformedResults) {
        if (path == null) {
            throw new NullPointerException("path");
        }
        switch (PathType.of(path)) {
            case JAR: {
                this.loadJar(path, saveTransformedResults);
                break;
            }
            case FOLDER: {
                this.loadFolder(path, saveTransformedResults);
            }
        }
        this.afterTransform.stream().forEach(handler -> handler.accept(this));
    }

    public void transform(@NonNull Path load, @NonNull Path save) {
        if (load == null) {
            throw new NullPointerException("load");
        }
        if (save == null) {
            throw new NullPointerException("save");
        }
        this.load(load, true);
        this.save(save);
        this.clear();
    }

    private void loadFolder(final Path input, final boolean saveTransformedResults) {
        try {
            Files.walkFileTree(input, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

                @Override
                public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                    String relativeName = input.relativize(file).toString();
                    Supplier<byte[]> supplier = JavaTransformer.this.transformBytes(() -> {
                        try {
                            return Files.readAllBytes(file);
                        }
                        catch (IOException e) {
                            throw new UncheckedIOException(e);
                        }
                    }, relativeName);
                    JavaTransformer.this.saveTransformedResult(relativeName, supplier, saveTransformedResults);
                    return FileVisitResult.CONTINUE;
                }
            });
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    private void loadJar(Path p, boolean saveTransformedResults) {
        try (ZipInputStream is = new ZipInputStream(new BufferedInputStream(new FileInputStream(p.toFile())));){
            ZipEntry entry;
            while ((entry = is.getNextEntry()) != null) {
                this.saveTransformedResult(entry.getName(), this.transformBytes(() -> JavaTransformer.readFully(is), entry.getName()), saveTransformedResults);
            }
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    private void saveTransformedResult(String relativeName, Supplier<byte[]> supplier, boolean saveTransformedResults) {
        if (saveTransformedResults) {
            this.transformedFiles.put(relativeName, supplier.get());
        }
    }

    private void saveFolder(Path output) {
        this.transformedFiles.forEach((fileName, bytes) -> {
            Path outputFile = output.resolve((String)fileName);
            try {
                if (Files.exists(outputFile, new LinkOption[0])) {
                    throw new IOException("Output file already exists: " + outputFile);
                }
                Files.createDirectories(outputFile.getParent(), new FileAttribute[0]);
                Files.write(outputFile, bytes, new OpenOption[0]);
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
        });
    }

    private void saveJar(Path jar) {
        try (ZipOutputStream os = new ZipOutputStream(new BufferedOutputStream(new FileOutputStream(jar.toFile())));){
            this.transformedFiles.forEach((relativeName, bytes) -> {
                try {
                    os.putNextEntry(new ZipEntry((String)relativeName));
                    os.write((byte[])bytes);
                }
                catch (IOException e) {
                    throw new UncheckedIOException(e);
                }
            });
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void clear() {
        this.transformedFiles.clear();
    }

    public void addTransformer(@NonNull Transformer.TargetedTransformer t) {
        if (t == null) {
            throw new NullPointerException("t");
        }
        if (this.transformers.contains(t)) {
            throw new IllegalArgumentException("Transformer " + t + " has already been added");
        }
        for (String name : t.getTargetClasses()) {
            this.classTransformers.put(name, t);
        }
    }

    public void addTransformer(@NonNull String s, @NonNull Transformer t) {
        if (s == null) {
            throw new NullPointerException("s");
        }
        if (t == null) {
            throw new NullPointerException("t");
        }
        if (this.classTransformers.get(s).contains(t)) {
            throw new IllegalArgumentException("Transformer " + t + " has already been added for class " + s);
        }
        this.classTransformers.put(s, t);
    }

    public void addTransformer(@NonNull Transformer t) {
        if (t == null) {
            throw new NullPointerException("t");
        }
        if (t instanceof Transformer.TargetedTransformer) {
            this.addTransformer((Transformer.TargetedTransformer)t);
            return;
        }
        if (this.transformers.contains(t)) {
            throw new IllegalArgumentException("Transformer " + t + " has already been added");
        }
        this.transformers.add(t);
    }

    public Supplier<byte[]> transformJava(@NonNull Supplier<byte[]> data, @NonNull String name) {
        if (data == null) {
            throw new NullPointerException("data");
        }
        if (name == null) {
            throw new NullPointerException("name");
        }
        if (!this.shouldTransform(name)) {
            return data;
        }
        CachingSupplier<ClassOrInterfaceDeclaration> supplier = CachingSupplier.of(() -> {
            CompilationUnit cu;
            byte[] bytes = (byte[])data.get();
            try {
                cu = JavaParser.parse(new ByteArrayInputStream(bytes));
            }
            catch (ParseException e) {
                throw new TransformationException(e);
            }
            ArrayList<String> tried = new ArrayList<String>();
            String packageName = NodeUtil.qualifiedName(cu.getPackage().getName());
            for (TypeDeclaration typeDeclaration : cu.getTypes()) {
                if (!(typeDeclaration instanceof ClassOrInterfaceDeclaration)) continue;
                ClassOrInterfaceDeclaration classDeclaration = (ClassOrInterfaceDeclaration)typeDeclaration;
                String shortClassName = classDeclaration.getName();
                String fullName = packageName + '.' + shortClassName;
                if (fullName.equalsIgnoreCase(name)) {
                    return classDeclaration;
                }
                tried.add(fullName);
            }
            throw new Error("Couldn't find any class or interface declaration matching expected name " + name + "\nTried: " + tried + "\nClass data: " + new String(bytes, Charset.forName("UTF-8")));
        });
        this.transformClassInfo(new SourceInfo(supplier, name));
        return supplier.isCached() ? () -> ((ClassOrInterfaceDeclaration)supplier.get()).getParentNode().toString().getBytes(Charset.forName("UTF-8")) : data;
    }

    public Supplier<byte[]> transformClass(@NonNull Supplier<byte[]> data, @NonNull String name) {
        if (data == null) {
            throw new NullPointerException("data");
        }
        if (name == null) {
            throw new NullPointerException("name");
        }
        if (!this.shouldTransform(name)) {
            return data;
        }
        Holder readerHolder = new Holder();
        CachingSupplier<ClassNode> supplier = CachingSupplier.of(() -> {
            ClassNode node = new ClassNode();
            ClassReader reader = new ClassReader((byte[])data.get());
            reader.accept((ClassVisitor)node, 8);
            readerHolder.value = reader;
            return node;
        });
        HashMap<String, String> filters = new HashMap<String, String>();
        this.transformClassInfo(new ByteCodeInfo(supplier, name, filters));
        if (!supplier.isCached()) {
            return data;
        }
        return () -> {
            if (readerHolder.value == null) {
                throw new IllegalStateException();
            }
            FilteringClassWriter classWriter = new FilteringClassWriter((ClassReader)readerHolder.value, 1);
            classWriter.filters.putAll(filters);
            ((ClassNode)supplier.get()).accept((ClassVisitor)classWriter);
            return classWriter.toByteArray();
        };
    }

    private void transformClassInfo(ClassInfo editor) {
        this.transformers.forEach(x -> x.transform(editor));
        this.classTransformers.get(editor.getName()).forEach(it -> it.transform(editor));
    }

    private boolean shouldTransform(String className) {
        return !this.transformers.isEmpty() || !this.classTransformers.get(className).isEmpty();
    }

    Supplier<byte[]> transformBytes(Supplier<byte[]> dataSupplier, String relativeName) {
        boolean isClass = relativeName.endsWith(".class");
        boolean isSource = relativeName.endsWith(".java");
        if (isClass || isSource) {
            String className = JVMUtil.fileNameToClassName(relativeName);
            if (className.endsWith(".package-info")) {
                return dataSupplier;
            }
            if (isClass) {
                return this.transformClass(dataSupplier, className);
            }
            return this.transformJava(dataSupplier, className);
        }
        return dataSupplier;
    }

    public List<Transformer> getTransformers() {
        return this.transformers;
    }

    public Map<String, byte[]> getTransformedFiles() {
        return this.transformedFiles;
    }

    public List<Consumer<JavaTransformer>> getAfterTransform() {
        return this.afterTransform;
    }

    public String toString() {
        return "JavaTransformer(transformers=" + this.getTransformers() + ", classTransformers=" + this.getClassTransformers() + ", transformedFiles=" + this.getTransformedFiles() + ", afterTransform=" + this.getAfterTransform() + ")";
    }

    private static class Holder<T> {
        public T value;

        private Holder() {
        }
    }

    private static class SimpleMultiMap<K, T> {
        private final Map<K, List<T>> map = new HashMap<K, List<T>>();

        private SimpleMultiMap() {
        }

        public void put(K key, T value) {
            List<T> values = this.map.get(key);
            if (values == null) {
                values = new ArrayList<T>();
                this.map.put(key, values);
            }
            values.add(value);
        }

        public List<T> get(K key) {
            List<T> values = this.map.get(key);
            return values == null ? Collections.emptyList() : values;
        }

        public String toString() {
            return this.map.toString();
        }
    }

    private static enum PathType {
        JAR,
        FOLDER;


        static PathType of(Path p) {
            if (!p.getFileName().toString().contains(".")) {
                if (Files.exists(p, new LinkOption[0]) && !Files.isDirectory(p, new LinkOption[0])) {
                    throw new TransformationException("Path " + p + " should be a directory or not already exist");
                }
                return FOLDER;
            }
            if (Files.isDirectory(p, new LinkOption[0])) {
                throw new TransformationException("Path " + p + " should be a file or not already exist");
            }
            return JAR;
        }
    }
}

