/*
 * Decompiled with CFR 0.152.
 */
package me.nallar.modpatcher;

import com.google.common.base.Charsets;
import com.google.common.io.Resources;
import java.io.IOError;
import java.io.IOException;
import java.io.InputStream;
import java.io.InterruptedIOException;
import java.lang.reflect.Method;
import java.net.URL;
import java.net.URLClassLoader;
import java.nio.charset.Charset;
import java.nio.file.CopyOption;
import java.nio.file.FileSystem;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.FutureTask;
import me.nallar.javapatcher.patcher.Patcher;
import me.nallar.modpatcher.ModPatcherLoadHook;
import me.nallar.modpatcher.ModPatcherTransformer;
import net.minecraft.launchwrapper.LaunchClassLoader;
import net.minecraftforge.fml.relauncher.ReflectionHelper;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ModPatcher {
    private static final int API_VERSION = 1;
    private static final Logger log = LogManager.getLogger((String)"ModPatcher");
    private static final String mcVersion = "1.10";
    private static final Path neverUpdatePath = ModPatcher.realPath("mods/ModPatcher_NEVER_UPDATE.txt");
    private static final Path modPatcherPath = ModPatcher.realPath("mods/ModPatcher.jlib");
    private static final boolean modPatcherPresent = Files.exists(modPatcherPath, new LinkOption[0]);
    private static final Future<Boolean> defaultUpdateRequired = CompletableFuture.completedFuture(!modPatcherPresent);
    private static final String DOWNLOAD_URL_PROPERTY = "modpatcher.downloadUrl";
    private static final String REQUIRED_VERSION_PROPERTY = "modpatcher.requiredVersion";
    private static final String RELEASE_PROPERTY = "modpatcher.release";
    private static final String VERSION_URL_PROPERTY = "modpatcher.versionUrl";
    private static final String NEVER_UPDATE_PROPERTY = "modpatcher.neverUpdate";
    private static final String DEFAULT_RELEASE = "stable";
    private static final String MODPATCHER_PACKAGE = "me.nallar.modpatcher";
    private static String modPatcherRelease;
    private static Future<Boolean> updateRequired;
    private static Version requiredVersion;
    private static Version lastVersion;
    private static boolean checked;

    public static String getSetupClass() {
        return "me.nallar.modpatcher.ModPatcherSetup";
    }

    public static void requireVersion(String versionString) {
        ModPatcher.requireVersion(versionString, null);
    }

    public static void requireVersion(String versionString, String release) {
        ModPatcher.requireVersionInternal(versionString, release);
    }

    public static void loadPatches(InputStream inputStream) {
        ModPatcher.getPatcher().loadPatches(inputStream);
    }

    public static void loadPatches(String patches) {
        ModPatcher.getPatcher().loadPatches(patches);
    }

    @Deprecated
    public static Patcher getPatcher() {
        ModPatcher.checkClassLoading();
        return ModPatcherTransformer.getPatcher();
    }

    public static void loadMixins(String mixinPackage) {
        ModPatcher.checkClassLoading();
        ModPatcherTransformer.getMixinApplicator().addSource(mixinPackage);
    }

    public static void loadMixins(Path path) {
        ModPatcher.checkClassLoading();
        ModPatcherTransformer.getMixinApplicator().addSource(path);
    }

    public static void loadMixins(Path path, String packageName) {
        ModPatcher.checkClassLoading();
        ModPatcherTransformer.getMixinApplicator().addSource(path, packageName);
    }

    public static String getDefaultPatchesDirectory() {
        ModPatcher.checkClassLoading();
        return ModPatcherTransformer.getDefaultPatchesDirectory();
    }

    static void initialiseClassLoader(LaunchClassLoader classLoader) {
        ModPatcher.checkClassLoading();
        ModPatcherTransformer.initialiseClassLoader(classLoader);
    }

    private static Path realPath(String s) {
        Path absolute = Paths.get(s, new String[0]).toAbsolutePath();
        try {
            return absolute.toRealPath(new LinkOption[0]);
        }
        catch (IOException e) {
            return absolute;
        }
    }

    private static void requireVersionInternal(String versionString, String release) {
        Version requested;
        if (updateRequired == null) {
            throw new Error("Modpatcher has already been loaded, it is too late to call getSetupClass");
        }
        versionString = System.getProperty(REQUIRED_VERSION_PROPERTY, versionString);
        if ((release = System.getProperty(RELEASE_PROPERTY, release)) != null && versionString == null) {
            throw new IllegalArgumentException("versionString must be non-null if release is non-null");
        }
        boolean startCheck = false;
        if (release != null) {
            if (modPatcherRelease == null) {
                modPatcherRelease = release;
                startCheck = true;
            } else {
                log.warn("Conflicting ModPatcher release requests. Set to " + modPatcherRelease + ", requested: " + release);
            }
        }
        if (versionString != null && (requested = Version.of(versionString)).compareTo(requiredVersion) > 0) {
            requiredVersion = requested;
            startCheck = true;
        }
        if (startCheck) {
            ModPatcher.startVersionCheck();
        }
    }

    private static void loadModPatcher() {
        if (ModPatcher.neverUpdate() && !modPatcherPresent) {
            throw new Error("ModPatcher is set to never update, but the ModPatcher library (ModPatcher.jlib) is not in the mods folder.\nAs automatic updating is disabled, we can not retrieve a compatible version of ModPatcher.");
        }
        ModPatcher.download();
        updateRequired = null;
        ModPatcher.addToCurrentClassLoader();
        ModPatcher.checkClassLoading(false);
    }

    private static String getModPatcherRelease() {
        return "1.10-" + (modPatcherRelease == null ? DEFAULT_RELEASE : modPatcherRelease);
    }

    private static void addToCurrentClassLoader() {
        ClassLoader cl = ModPatcher.class.getClassLoader();
        try {
            URL url = modPatcherPath.toUri().toURL();
            log.trace("Adding " + url + " to classloader");
            if (cl instanceof LaunchClassLoader) {
                LaunchClassLoader lcl = (LaunchClassLoader)cl;
                lcl.addTransformerExclusion(MODPATCHER_PACKAGE);
                lcl.addURL(url);
                Set invalidClasses = (Set)ReflectionHelper.getPrivateValue(LaunchClassLoader.class, (Object)lcl, (String[])new String[]{"invalidClasses"});
                Set negativeResources = (Set)ReflectionHelper.getPrivateValue(LaunchClassLoader.class, (Object)lcl, (String[])new String[]{"negativeResourceCache"});
                invalidClasses.removeIf(ModPatcher::removeModPatcherEntries);
                negativeResources.removeIf(ModPatcher::removeModPatcherEntries);
                log.trace("Loaded class: " + Class.forName("me.nallar.modpatcher.ModPatcherLoadHook"));
            } else {
                Method method = URLClassLoader.class.getDeclaredMethod("addURL", URL.class);
                method.setAccessible(true);
                method.invoke((Object)cl, url);
            }
        }
        catch (Exception e) {
            throw new Error(e);
        }
    }

    private static boolean removeModPatcherEntries(String entry) {
        return entry.replace('/', '.').startsWith(MODPATCHER_PACKAGE);
    }

    static boolean neverUpdate() {
        return "true".equals(System.getProperty(NEVER_UPDATE_PROPERTY)) || Files.exists(neverUpdatePath, new LinkOption[0]);
    }

    private static boolean isDownloadNeeded() {
        if (ModPatcher.neverUpdate()) {
            return false;
        }
        try {
            return updateRequired.get();
        }
        catch (InterruptedException | ExecutionException e) {
            log.warn("Failed to check if updates are required", (Throwable)e);
            return false;
        }
    }

    private static void download() {
        if (!ModPatcher.isDownloadNeeded()) {
            return;
        }
        try (InputStream in = new URL(System.getProperty(DOWNLOAD_URL_PROPERTY, "https://modpatcher.nallar.me/" + ModPatcher.getModPatcherRelease() + "/ModPatcher-lib.jar")).openConnection().getInputStream();){
            Files.deleteIfExists(modPatcherPath);
            Files.createDirectories(modPatcherPath.getParent(), new FileAttribute[0]);
            Files.copy(in, modPatcherPath, new CopyOption[0]);
        }
        catch (IOException e) {
            log.error("Failed to download ModPatcher", (Throwable)e);
        }
    }

    private static void checkClassLoading() {
        ModPatcher.checkClassLoading(true);
    }

    private static void checkClassLoading(boolean load) {
        if (checked) {
            return;
        }
        try {
            Class.forName("me.nallar.modpatcher.ModPatcherLoadHook");
            ModPatcherLoadHook.loadHook(requiredVersion, ModPatcher.getModPatcherRelease(), 1);
            checked = true;
        }
        catch (ClassNotFoundException | NoClassDefFoundError e) {
            if (!load) {
                throw new Error(e);
            }
            ModPatcher.loadModPatcher();
        }
    }

    private static void startVersionCheck() {
        if (ModPatcher.neverUpdate() || requiredVersion == null) {
            return;
        }
        updateRequired.cancel(true);
        try {
            if (!updateRequired.isDone() || updateRequired.isCancelled() || !updateRequired.get().booleanValue()) {
                FutureTask<Boolean> task = new FutureTask<Boolean>(() -> {
                    Version current;
                    try {
                        current = ModPatcher.getLastVersion();
                    }
                    catch (Exception e) {
                        current = Version.NONE;
                        log.warn("Failed to determine current ModPatcher version, assuming it is outdated", (Throwable)e);
                    }
                    if (requiredVersion.newerThan(current)) {
                        try {
                            Version online = new Version(Resources.toString((URL)new URL(System.getProperty(VERSION_URL_PROPERTY, "https://modpatcher.nallar.me/" + ModPatcher.getModPatcherRelease() + "/version.txt")), (Charset)Charsets.UTF_8).trim());
                            return online.compareTo(current) > 0;
                        }
                        catch (InterruptedIOException online) {
                        }
                        catch (Throwable t) {
                            log.warn("Failed to check for update", t);
                        }
                    }
                    return false;
                });
                updateRequired = task;
                task.run();
            }
        }
        catch (InterruptedException | ExecutionException e) {
            log.warn("Interrupted when checking done/not cancelled future", (Throwable)e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    static Version getLastVersion() {
        if (lastVersion != null) {
            return lastVersion;
        }
        if (!Files.exists(modPatcherPath, new LinkOption[0])) {
            return Version.NONE;
        }
        try (FileSystem fs = FileSystems.newFileSystem(modPatcherPath, null);){
            Version version = lastVersion = new Version(Files.readAllLines(fs.getPath("modpatcher.version", new String[0]), Charsets.UTF_8).get(0));
            return version;
        }
        catch (IOException e) {
            throw new IOError(e);
        }
    }

    static {
        updateRequired = defaultUpdateRequired;
        checked = false;
        ModPatcher.requireVersionInternal(null, null);
    }

    static class Version
    implements Comparable<Version> {
        public static final Version LATEST = new Version(String.valueOf(Integer.MAX_VALUE));
        public static final Version NONE = new Version("0");
        private String version;
        private boolean snapshot;

        private Version(String version) {
            if (version == null) {
                throw new IllegalArgumentException("Version can not be null");
            }
            if ((version = version.trim()).endsWith("-SNAPSHOT")) {
                version = version.replace("-SNAPSHOT", "");
                this.snapshot = true;
            }
            if (!version.matches("[0-9]+(\\.[0-9]+)*")) {
                throw new IllegalArgumentException("Invalid version format. Should consist entirely of digits and dots. Got '" + version + "'");
            }
            this.version = version;
        }

        static Version of(String s) {
            if (s.equalsIgnoreCase("latest")) {
                return LATEST;
            }
            return new Version(s);
        }

        @Override
        public int compareTo(Version that) {
            if (that == null) {
                return 1;
            }
            if (this == that || this.version.equals(that.version)) {
                return 0;
            }
            String[] thisParts = this.version.split("\\.");
            String[] thatParts = that.version.split("\\.");
            int length = Math.max(thisParts.length, thatParts.length);
            for (int i = 0; i < length; ++i) {
                int thatPart;
                int thisPart = i < thisParts.length ? Integer.parseInt(thisParts[i]) : 0;
                int n = thatPart = i < thatParts.length ? Integer.parseInt(thatParts[i]) : 0;
                if (this.snapshot && i >= thisParts.length) {
                    thisPart = Integer.MAX_VALUE;
                }
                if (that.snapshot && i >= thatParts.length) {
                    thatPart = Integer.MAX_VALUE;
                }
                if (thisPart < thatPart) {
                    return -1;
                }
                if (thisPart <= thatPart) continue;
                return 1;
            }
            return this.snapshot == that.snapshot ? 0 : (this.snapshot ? 1 : -1);
        }

        public String toString() {
            return this.version + (this.snapshot ? "-SNAPSHOT" : "");
        }

        public int hashCode() {
            return this.toString().hashCode();
        }

        public boolean equals(Object that) {
            return this == that || that != null && this.getClass() == that.getClass() && this.compareTo((Version)that) == 0;
        }

        public boolean newerThan(Version other) {
            return this.compareTo(other) > 0;
        }
    }
}

