/*
 * Decompiled with CFR 0.152.
 */
package me.nallar.javatransformer.internal;

import com.github.javaparser.ASTHelper;
import com.github.javaparser.ast.CompilationUnit;
import com.github.javaparser.ast.body.BodyDeclaration;
import com.github.javaparser.ast.body.ClassOrInterfaceDeclaration;
import com.github.javaparser.ast.body.ConstructorDeclaration;
import com.github.javaparser.ast.body.FieldDeclaration;
import com.github.javaparser.ast.body.MethodDeclaration;
import com.github.javaparser.ast.body.VariableDeclarator;
import com.github.javaparser.ast.body.VariableDeclaratorId;
import com.github.javaparser.ast.expr.AnnotationExpr;
import com.github.javaparser.ast.expr.Expression;
import com.github.javaparser.ast.expr.MethodCallExpr;
import com.github.javaparser.ast.expr.NameExpr;
import com.github.javaparser.ast.expr.ObjectCreationExpr;
import com.github.javaparser.ast.expr.TypeExpr;
import com.github.javaparser.ast.expr.VariableDeclarationExpr;
import com.github.javaparser.ast.stmt.BlockStmt;
import com.github.javaparser.ast.stmt.ThrowStmt;
import com.github.javaparser.ast.type.ClassOrInterfaceType;
import com.github.javaparser.ast.type.PrimitiveType;
import java.beans.ConstructorProperties;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import me.nallar.javatransformer.api.AccessFlags;
import me.nallar.javatransformer.api.Annotation;
import me.nallar.javatransformer.api.ClassInfo;
import me.nallar.javatransformer.api.FieldInfo;
import me.nallar.javatransformer.api.MethodInfo;
import me.nallar.javatransformer.api.Parameter;
import me.nallar.javatransformer.api.TransformationException;
import me.nallar.javatransformer.api.Type;
import me.nallar.javatransformer.api.TypeVariable;
import me.nallar.javatransformer.internal.ClassInfoStreams;
import me.nallar.javatransformer.internal.ResolutionContext;
import me.nallar.javatransformer.internal.SimpleFieldInfo;
import me.nallar.javatransformer.internal.SimpleMethodInfo;
import me.nallar.javatransformer.internal.util.AnnotationParser;
import me.nallar.javatransformer.internal.util.JVMUtil;
import me.nallar.javatransformer.internal.util.NodeUtil;

public class SourceInfo
implements ClassInfoStreams {
    private final Supplier<ClassOrInterfaceDeclaration> type;
    private final AtomicReference<Object> packageName = new AtomicReference();
    private final AtomicReference<Object> context = new AtomicReference();
    private final AtomicReference<Object> annotations = new AtomicReference();
    private String className;

    static void changeTypeContext(ResolutionContext old, ResolutionContext new_, FieldDeclaration f) {
        f.setType(SourceInfo.changeTypeContext(old, new_, f.getType()));
    }

    static com.github.javaparser.ast.type.Type changeTypeContext(ResolutionContext old, ResolutionContext new_, com.github.javaparser.ast.type.Type t) {
        Type current = old.resolve(t);
        if (current.isClassType()) {
            return ResolutionContext.typeToJavaParserType(current.remapClassNames(new_::typeToJavaParserType));
        }
        return t;
    }

    private String getPackageNameInternal() {
        return NodeUtil.qualifiedName(NodeUtil.getParentNode(this.type.get(), CompilationUnit.class).getPackage().getName());
    }

    private ResolutionContext getContextInternal() {
        return ResolutionContext.of(this.type.get());
    }

    @Override
    public String getName() {
        return this.className;
    }

    @Override
    public void setName(String name) {
        String packageName = this.getPackageName();
        if (!name.startsWith(packageName)) {
            throw new TransformationException("Name '" + name + "' must be in package: " + packageName);
        }
        this.type.get().setName(name.replace(packageName, ""));
    }

    @Override
    public AccessFlags getAccessFlags() {
        return new AccessFlags(this.type.get().getModifiers());
    }

    @Override
    public void setAccessFlags(AccessFlags accessFlags) {
        this.type.get().setModifiers(accessFlags.access);
    }

    @Override
    public void add(MethodInfo method) {
        MethodDeclaration methodDeclaration;
        if (method instanceof MethodDeclarationWrapper) {
            MethodDeclarationWrapper wrapper = (MethodDeclarationWrapper)method;
            methodDeclaration = (MethodDeclaration)wrapper.declaration.clone();
            methodDeclaration.setAnnotations(Collections.emptyList());
            wrapper.getClassInfo().changeTypeContext(wrapper.getContext(), this.getContext(), methodDeclaration);
        } else {
            methodDeclaration = new MethodDeclaration();
            new MethodDeclarationWrapper(methodDeclaration).setAll(method);
        }
        this.addMember(methodDeclaration);
    }

    @Override
    public void add(FieldInfo field) {
        FieldDeclaration fieldDeclaration;
        if (field instanceof FieldDeclarationWrapper) {
            FieldDeclarationWrapper wrapper = (FieldDeclarationWrapper)field;
            fieldDeclaration = (FieldDeclaration)wrapper.declaration.clone();
            fieldDeclaration.setAnnotations(Collections.emptyList());
            SourceInfo.changeTypeContext(wrapper.getContext(), this.getContext(), fieldDeclaration);
        } else {
            fieldDeclaration = new FieldDeclaration();
            ArrayList<VariableDeclarator> vars = new ArrayList<VariableDeclarator>();
            vars.add(new VariableDeclarator(new VariableDeclaratorId("unknown")));
            fieldDeclaration.setVariables(vars);
            new FieldDeclarationWrapper(fieldDeclaration).setAll(field);
        }
        this.addMember(fieldDeclaration);
        FieldDeclarationWrapper result = new FieldDeclarationWrapper(fieldDeclaration);
        if (!field.similar(result)) {
            throw new TransformationException("After adding to class, didn't match. added: " + field + " result: " + result);
        }
    }

    private void addMember(BodyDeclaration bodyDeclaration) {
        bodyDeclaration.setParentNode(this.type.get());
        this.type.get().getMembers().add(bodyDeclaration);
    }

    void changeTypeContext(ResolutionContext old, ResolutionContext new_, MethodDeclaration m) {
        m.setType(SourceInfo.changeTypeContext(old, new_, m.getType()));
        m.setBody(new BlockStmt(Collections.singletonList(new ThrowStmt(new ObjectCreationExpr(null, new ClassOrInterfaceType("UnsupportedOperationException"), Collections.emptyList())))));
        NodeUtil.forChildren(m, node -> {
            Expression scope = node.getScope();
            if (scope instanceof NameExpr && Character.isUpperCase(((NameExpr)scope).getName().charAt(0))) {
                String name = ((NameExpr)scope).getName();
                node.setScope(ASTHelper.createNameExpr(new_.typeToString(old.resolve(name))));
            }
        }, MethodCallExpr.class);
        NodeUtil.forChildren(m, node -> node.setType(SourceInfo.changeTypeContext(old, new_, node.getType())), VariableDeclarationExpr.class);
        NodeUtil.forChildren(m, node -> node.setType(SourceInfo.changeTypeContext(old, new_, node.getType())), TypeExpr.class);
        NodeUtil.forChildren(m, node -> node.setType(SourceInfo.changeTypeContext(old, new_, node.getType())), com.github.javaparser.ast.body.Parameter.class);
    }

    @Override
    public void remove(MethodInfo method) {
        MethodDeclarationWrapper methodDeclarationWrapper;
        MethodDeclarationWrapper methodDeclarationWrapper2 = methodDeclarationWrapper = !(method instanceof MethodDeclarationWrapper) ? (MethodDeclarationWrapper)this.get(method) : (MethodDeclarationWrapper)method;
        if (methodDeclarationWrapper == null) {
            throw new TransformationException("Method " + method + " can not be removed as it is not present");
        }
        this.type.get().getMembers().remove(methodDeclarationWrapper.declaration);
    }

    @Override
    public void remove(FieldInfo field) {
        FieldDeclarationWrapper fieldDeclarationWrapper;
        FieldDeclarationWrapper fieldDeclarationWrapper2 = fieldDeclarationWrapper = !(field instanceof FieldDeclarationWrapper) ? (FieldDeclarationWrapper)this.get(field) : (FieldDeclarationWrapper)field;
        if (fieldDeclarationWrapper == null) {
            throw new TransformationException("Field " + field + " can not be removed as it is not present");
        }
        this.type.get().getMembers().remove(fieldDeclarationWrapper.declaration);
    }

    @Override
    public Type getSuperType() {
        List<ClassOrInterfaceType> extends_ = this.type.get().getExtends();
        if (extends_ == null || extends_.isEmpty()) {
            return null;
        }
        return this.getContext().resolve(extends_.get(0));
    }

    @Override
    public List<Type> getInterfaceTypes() {
        return this.type.get().getImplements().stream().map(this.getContext()::resolve).collect(Collectors.toList());
    }

    @Override
    public Stream<MethodInfo> getMethodStream() {
        return this.type.get().getMembers().stream().map(this::getMethodInfoWrapper).filter(Objects::nonNull);
    }

    private MethodInfo getMethodInfoWrapper(BodyDeclaration x) {
        if (x instanceof MethodDeclaration) {
            return new MethodDeclarationWrapper((MethodDeclaration)x);
        }
        if (x instanceof ConstructorDeclaration) {
            return new ConstructorDeclarationWrapper((ConstructorDeclaration)x);
        }
        return null;
    }

    @Override
    public Stream<FieldInfo> getFieldStream() {
        return this.type.get().getMembers().stream().filter(x -> x instanceof FieldDeclaration).map(x -> new FieldDeclarationWrapper((FieldDeclaration)x));
    }

    private com.github.javaparser.ast.type.Type toType(Type t) {
        String name = this.getContext().typeToString(t);
        if (t.isPrimitiveType()) {
            return new PrimitiveType(JVMUtil.searchEnum(PrimitiveType.Primitive.class, name));
        }
        return new ClassOrInterfaceType(name);
    }

    private com.github.javaparser.ast.type.Type setType(Type newType, com.github.javaparser.ast.type.Type currentType) {
        List<AnnotationExpr> annotations;
        com.github.javaparser.ast.type.Type newType_ = this.toType(newType);
        if (currentType instanceof ClassOrInterfaceType && newType_ instanceof ClassOrInterfaceType && (annotations = currentType.getAnnotations()) != null && !annotations.isEmpty()) {
            newType_.setAnnotations(annotations);
        }
        return newType_;
    }

    private List<Annotation> getAnnotationsInternal() {
        return this.getAnnotationsInternal(this.type.get().getAnnotations());
    }

    private List<Annotation> getAnnotationsInternal(List<AnnotationExpr> l) {
        return l.stream().map(AnnotationParser::annotationFromAnnotationExpr).collect(Collectors.toList());
    }

    @Override
    public ClassInfo getClassInfo() {
        return this;
    }

    public String getClassName() {
        return this.className;
    }

    public void setClassName(String className) {
        this.className = className;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof SourceInfo)) {
            return false;
        }
        SourceInfo other = (SourceInfo)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Supplier<ClassOrInterfaceDeclaration> this$type = this.type;
        Supplier<ClassOrInterfaceDeclaration> other$type = other.type;
        if (this$type == null ? other$type != null : !this$type.equals(other$type)) {
            return false;
        }
        String this$packageName = this.getPackageName();
        String other$packageName = other.getPackageName();
        if (this$packageName == null ? other$packageName != null : !this$packageName.equals(other$packageName)) {
            return false;
        }
        ResolutionContext this$context = this.getContext();
        ResolutionContext other$context = other.getContext();
        if (this$context == null ? other$context != null : !this$context.equals(other$context)) {
            return false;
        }
        List<Annotation> this$annotations = this.getAnnotations();
        List<Annotation> other$annotations = other.getAnnotations();
        if (this$annotations == null ? other$annotations != null : !((Object)this$annotations).equals(other$annotations)) {
            return false;
        }
        String this$className = this.getClassName();
        String other$className = other.getClassName();
        return !(this$className == null ? other$className != null : !this$className.equals(other$className));
    }

    protected boolean canEqual(Object other) {
        return other instanceof SourceInfo;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Supplier<ClassOrInterfaceDeclaration> $type = this.type;
        result = result * 59 + ($type == null ? 0 : $type.hashCode());
        String $packageName = this.getPackageName();
        result = result * 59 + ($packageName == null ? 0 : $packageName.hashCode());
        ResolutionContext $context = this.getContext();
        result = result * 59 + ($context == null ? 0 : $context.hashCode());
        List<Annotation> $annotations = this.getAnnotations();
        result = result * 59 + ($annotations == null ? 0 : ((Object)$annotations).hashCode());
        String $className = this.getClassName();
        result = result * 59 + ($className == null ? 0 : $className.hashCode());
        return result;
    }

    public String toString() {
        return "SourceInfo(type=" + this.type + ", packageName=" + this.getPackageName() + ", context=" + this.getContext() + ", annotations=" + this.getAnnotations() + ", className=" + this.getClassName() + ")";
    }

    @ConstructorProperties(value={"type", "className"})
    public SourceInfo(Supplier<ClassOrInterfaceDeclaration> type, String className) {
        this.type = type;
        this.className = className;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getPackageName() {
        Object value = this.packageName.get();
        if (value == null) {
            AtomicReference<Object> atomicReference = this.packageName;
            synchronized (atomicReference) {
                value = this.packageName.get();
                if (value == null) {
                    String actualValue = this.getPackageNameInternal();
                    value = actualValue == null ? this.packageName : actualValue;
                    this.packageName.set(value);
                }
            }
        }
        return (String)(value == this.packageName ? null : value);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ResolutionContext getContext() {
        Object value = this.context.get();
        if (value == null) {
            AtomicReference<Object> atomicReference = this.context;
            synchronized (atomicReference) {
                value = this.context.get();
                if (value == null) {
                    ResolutionContext actualValue = this.getContextInternal();
                    value = actualValue == null ? this.context : actualValue;
                    this.context.set(value);
                }
            }
        }
        return (ResolutionContext)(value == this.context ? null : value);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<Annotation> getAnnotations() {
        Object value = this.annotations.get();
        if (value == null) {
            AtomicReference<Object> atomicReference = this.annotations;
            synchronized (atomicReference) {
                value = this.annotations.get();
                if (value == null) {
                    List<Annotation> actualValue = this.getAnnotationsInternal();
                    value = actualValue == null ? this.annotations : actualValue;
                    this.annotations.set(value);
                }
            }
        }
        return (List)(value == this.annotations ? null : value);
    }

    class ConstructorDeclarationWrapper
    implements MethodInfo {
        private final ConstructorDeclaration declaration;
        private ResolutionContext context;

        public ConstructorDeclarationWrapper(ConstructorDeclaration declaration) {
            this.declaration = declaration;
        }

        private ResolutionContext getContext() {
            if (this.context != null) {
                return this.context;
            }
            this.context = ResolutionContext.of(this.declaration);
            return this.context;
        }

        @Override
        public Type getReturnType() {
            return SourceInfo.this.getType();
        }

        @Override
        public void setReturnType(Type type) {
            throw new UnsupportedOperationException("Can't setReturnType of constructor");
        }

        @Override
        public List<Parameter> getParameters() {
            return this.declaration.getParameters().stream().map(parameter -> new Parameter(this.getContext().resolve(parameter.getType()), parameter.getId().getName())).collect(Collectors.toList());
        }

        @Override
        public void setParameters(List<Parameter> parameters) {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getName() {
            return "<init>";
        }

        @Override
        public void setName(String name) {
            throw new UnsupportedOperationException("Can't setName of constructor");
        }

        @Override
        public AccessFlags getAccessFlags() {
            return new AccessFlags(this.declaration.getModifiers());
        }

        @Override
        public void setAccessFlags(AccessFlags accessFlags) {
            this.declaration.setModifiers(accessFlags.access);
        }

        @Override
        public List<Annotation> getAnnotations() {
            return SourceInfo.this.getAnnotationsInternal(this.declaration.getAnnotations());
        }

        @Override
        public SourceInfo getClassInfo() {
            return SourceInfo.this;
        }

        public String toString() {
            return SimpleMethodInfo.toString(this);
        }

        @Override
        public List<TypeVariable> getTypeVariables() {
            return Collections.emptyList();
        }

        @Override
        public void setTypeVariables(List<TypeVariable> typeVariables) {
            throw new UnsupportedOperationException("Can't set type variables on a constructor");
        }
    }

    class MethodDeclarationWrapper
    implements MethodInfo {
        private final MethodDeclaration declaration;
        private ResolutionContext context;

        public MethodDeclarationWrapper(MethodDeclaration declaration) {
            this.declaration = declaration;
        }

        private ResolutionContext getContext() {
            if (this.context != null) {
                return this.context;
            }
            this.context = ResolutionContext.of(this.declaration);
            return this.context;
        }

        @Override
        public Type getReturnType() {
            return this.getContext().resolve(this.declaration.getType());
        }

        @Override
        public void setReturnType(Type type) {
            this.declaration.setType(SourceInfo.this.setType(type, this.declaration.getType()));
        }

        @Override
        public List<Parameter> getParameters() {
            return this.declaration.getParameters().stream().map(parameter -> new Parameter(this.getContext().resolve(parameter.getType()), parameter.getId().getName())).collect(Collectors.toList());
        }

        @Override
        public void setParameters(List<Parameter> parameters) {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getName() {
            return this.declaration.getName();
        }

        @Override
        public void setName(String name) {
            this.declaration.setName(name);
        }

        @Override
        public AccessFlags getAccessFlags() {
            return new AccessFlags(this.declaration.getModifiers());
        }

        @Override
        public void setAccessFlags(AccessFlags accessFlags) {
            this.declaration.setModifiers(accessFlags.access);
        }

        @Override
        public List<Annotation> getAnnotations() {
            return SourceInfo.this.getAnnotationsInternal(this.declaration.getAnnotations());
        }

        @Override
        public SourceInfo getClassInfo() {
            return SourceInfo.this;
        }

        public String toString() {
            return SimpleMethodInfo.toString(this);
        }

        @Override
        public List<TypeVariable> getTypeVariables() {
            return this.declaration.getTypeParameters().stream().map(this.getContext()::resolveTypeVariable).collect(Collectors.toList());
        }

        @Override
        public void setTypeVariables(List<TypeVariable> typeVariables) {
            this.declaration.setTypeParameters(typeVariables.stream().map(this.getContext()::unresolveTypeVariable).collect(Collectors.toList()));
        }
    }

    class FieldDeclarationWrapper
    implements FieldInfo {
        private final FieldDeclaration declaration;
        private ResolutionContext context;

        FieldDeclarationWrapper(FieldDeclaration declaration) {
            this.declaration = declaration;
            if (declaration.getVariables().size() != 1) {
                throw new UnsupportedOperationException("Not yet implemented: multiple variables in one field decl.");
            }
        }

        private ResolutionContext getContext() {
            if (this.context != null) {
                return this.context;
            }
            this.context = ResolutionContext.of(this.declaration);
            return this.context;
        }

        @Override
        public String getName() {
            return this.declaration.getVariables().get(0).getId().getName();
        }

        @Override
        public void setName(String name) {
            this.declaration.getVariables().get(0).getId().setName(name);
        }

        @Override
        public AccessFlags getAccessFlags() {
            return new AccessFlags(this.declaration.getModifiers());
        }

        @Override
        public void setAccessFlags(AccessFlags accessFlags) {
            this.declaration.setModifiers(accessFlags.access);
        }

        @Override
        public Type getType() {
            return this.getContext().resolve(this.declaration.getType());
        }

        @Override
        public void setType(Type type) {
            this.declaration.setType(SourceInfo.this.setType(type, this.declaration.getType()));
        }

        @Override
        public List<Annotation> getAnnotations() {
            return SourceInfo.this.getAnnotationsInternal(this.declaration.getAnnotations());
        }

        @Override
        public SourceInfo getClassInfo() {
            return SourceInfo.this;
        }

        public String toString() {
            return SimpleFieldInfo.toString(this);
        }
    }
}

