/*
 * Decompiled with CFR 0.152.
 */
package me.nallar.javatransformer.api;

import java.util.List;
import java.util.function.Function;
import me.nallar.javatransformer.api.AccessFlags;
import me.nallar.javatransformer.api.ClassMember;
import me.nallar.javatransformer.api.FieldInfo;
import me.nallar.javatransformer.api.MethodInfo;
import me.nallar.javatransformer.api.TransformationException;
import me.nallar.javatransformer.api.Type;

public interface ClassInfo
extends ClassMember {
    default public void add(ClassMember member) {
        if (member instanceof MethodInfo) {
            this.add((MethodInfo)member);
        } else if (member instanceof FieldInfo) {
            this.add((FieldInfo)member);
        } else {
            throw new TransformationException("Can't add member of type " + member.getClass().getCanonicalName() + " to " + this);
        }
    }

    public void add(MethodInfo var1);

    public void add(FieldInfo var1);

    default public void remove(ClassMember member) {
        if (member instanceof MethodInfo) {
            this.remove((MethodInfo)member);
        } else if (member instanceof FieldInfo) {
            this.remove((FieldInfo)member);
        } else {
            throw new TransformationException("Can't remove member of type " + member.getClass().getCanonicalName() + " to " + this);
        }
    }

    public void remove(MethodInfo var1);

    public void remove(FieldInfo var1);

    public Type getSuperType();

    public List<Type> getInterfaceTypes();

    default public ClassMember get(ClassMember member) {
        if (member instanceof MethodInfo) {
            return this.get((MethodInfo)member);
        }
        if (member instanceof FieldInfo) {
            return this.get((FieldInfo)member);
        }
        throw new TransformationException("Can't get member of type " + member.getClass().getCanonicalName() + " in " + this);
    }

    default public MethodInfo get(MethodInfo like) {
        for (MethodInfo methodInfo : this.getMethods()) {
            if (!like.similar(methodInfo)) continue;
            return methodInfo;
        }
        return null;
    }

    default public FieldInfo get(FieldInfo like) {
        for (FieldInfo fieldInfo : this.getFields()) {
            if (!like.similar(fieldInfo)) continue;
            return fieldInfo;
        }
        return null;
    }

    default public Type getType() {
        return Type.of(this.getName());
    }

    public List<MethodInfo> getMethods();

    public List<FieldInfo> getFields();

    public List<ClassMember> getMembers();

    @Override
    default public void accessFlags(Function<AccessFlags, AccessFlags> c) {
        this.setAccessFlags(c.apply(this.getAccessFlags()));
    }
}

