/*
 * Decompiled with CFR 0.152.
 */
package me.nallar.javatransformer.api;

import me.nallar.javatransformer.internal.util.JVMUtil;

public class AccessFlags {
    public static final int ACC_PUBLIC = 1;
    public static final int ACC_PRIVATE = 2;
    public static final int ACC_PROTECTED = 4;
    public static final int ACC_STATIC = 8;
    public static final int ACC_FINAL = 16;
    public static final int ACC_SUPER = 32;
    public static final int ACC_SYNCHRONIZED = 32;
    public static final int ACC_VOLATILE = 64;
    public static final int ACC_BRIDGE = 64;
    public static final int ACC_VARARGS = 128;
    public static final int ACC_TRANSIENT = 128;
    public static final int ACC_NATIVE = 256;
    public static final int ACC_INTERFACE = 512;
    public static final int ACC_ABSTRACT = 1024;
    public static final int ACC_STRICT = 2048;
    public static final int ACC_SYNTHETIC = 4096;
    public static final int ACC_ANNOTATION = 8192;
    public static final int ACC_ENUM = 16384;
    public static final int ACC_MANDATED = 32768;
    public final int access;

    public AccessFlags(int access) {
        this.access = access;
    }

    public String toString() {
        return "Access: " + this.access + " (" + JVMUtil.accessIntToString(this.access) + ")";
    }

    public boolean equals(Object o) {
        return o == this || o instanceof AccessFlags && ((AccessFlags)o).access == this.access;
    }

    public int hashCode() {
        return this.access;
    }

    public boolean has(int flag) {
        return (this.access & flag) == flag;
    }

    public AccessFlags makeAccessible(boolean needsPublic) {
        return new AccessFlags(JVMUtil.makeAccess(this.access, needsPublic));
    }

    public AccessFlags with(int flag) {
        return new AccessFlags(this.access | flag);
    }

    public AccessFlags without(int flag) {
        return new AccessFlags(this.access & ~flag);
    }
}

