/*
 * Decompiled with CFR 0.152.
 */
package me.nallar.modpatcher;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import javassist.ClassLoaderPool;
import me.nallar.javapatcher.patcher.Patcher;
import me.nallar.javapatcher.patcher.Patches;
import me.nallar.mixin.internal.MixinApplicator;
import me.nallar.modpatcher.LaunchClassLoaderUtil;
import me.nallar.modpatcher.MCPMappings;
import me.nallar.modpatcher.ModPatcherTweaker;
import me.nallar.modpatcher.PatcherLog;
import net.minecraft.launchwrapper.IClassTransformer;
import net.minecraft.launchwrapper.LaunchClassLoader;

class ModPatcherTransformer {
    public static final ClassLoaderPool pool;
    private static final String MOD_PATCHES_DIRECTORY = "./ModPatches/";
    private static final Patcher patcher;
    private static final String ALREADY_LOADED_PROPERTY_NAME = "nallar.ModPatcher.alreadyLoaded";
    private static final String DUMP_PROPERTY_NAME = "nallar.ModPatcher.dump";
    private static final boolean DUMP;
    private static boolean classLoaderInitialised;
    private static MixinApplicator mixinApplicator;

    ModPatcherTransformer() {
    }

    private static Error logError(String message, Throwable t) {
        PatcherLog.error(message, t);
        return new Error(message, t);
    }

    private static void checkForMultipleClassLoads() {
        if (System.getProperty(ALREADY_LOADED_PROPERTY_NAME) != null) {
            Error e = ModPatcherTransformer.logError("Detected multiple classloads of ModPatcher - classloading issue?", new Throwable());
            if (!System.getProperty(ALREADY_LOADED_PROPERTY_NAME).equals("breakEverything")) {
                throw e;
            }
        } else {
            System.setProperty(ALREADY_LOADED_PROPERTY_NAME, "true");
        }
    }

    static Patcher getPatcher() {
        return patcher;
    }

    private static void recursivelyAddXmlFiles(File directory, Patcher patcher) {
        File[] files = directory.listFiles();
        if (files == null) {
            return;
        }
        try {
            for (File f : files) {
                if (f.isDirectory()) {
                    ModPatcherTransformer.recursivelyAddXmlFiles(f, patcher);
                    continue;
                }
                if (f.getName().endsWith(".xml")) {
                    patcher.readPatchesFromXmlInputStream(new FileInputStream(f));
                    continue;
                }
                if (!f.getName().endsWith(".json")) continue;
                patcher.readPatchesFromJsonInputStream(new FileInputStream(f));
            }
        }
        catch (IOException e) {
            PatcherLog.warn("Failed to load patch", e);
        }
    }

    static byte[] transformationHook(String name, byte[] originalBytes) {
        LaunchClassLoaderUtil.cacheSrgBytes(name, originalBytes);
        if (mixinApplicator != null) {
            byte[] finalOriginalBytes = originalBytes;
            originalBytes = ModPatcherTransformer.getMixinApplicator().getMixinTransformer().transformClass(() -> finalOriginalBytes, name).get();
        }
        try {
            return patcher.patch(name, originalBytes);
        }
        catch (Throwable t) {
            PatcherLog.error("Failed to patch " + name, t);
            return originalBytes;
        }
    }

    static IClassTransformer getInstance() {
        return ClassTransformer.INSTANCE;
    }

    public static void initialiseClassLoader(LaunchClassLoader classLoader) {
        if (classLoaderInitialised) {
            return;
        }
        classLoaderInitialised = true;
        classLoader.addTransformerExclusion("me.nallar.");
        classLoader.addTransformerExclusion("nallar.");
        classLoader.addTransformerExclusion("javassist.");
        classLoader.addTransformerExclusion("com.github.javaparser.");
        LaunchClassLoaderUtil.instance = classLoader;
        ModPatcherTweaker.add();
        LaunchClassLoaderUtil.addTransformer(ModPatcherTransformer.getInstance());
        LaunchClassLoaderUtil.dumpTransformersIfEnabled();
        LaunchClassLoaderUtil.removeRedundantExclusions();
    }

    static String getDefaultPatchesDirectory() {
        return MOD_PATCHES_DIRECTORY;
    }

    static MixinApplicator getMixinApplicator() {
        MixinApplicator mixinApplicator = ModPatcherTransformer.mixinApplicator;
        if (mixinApplicator == null) {
            ModPatcherTransformer.mixinApplicator = mixinApplicator = new MixinApplicator();
            mixinApplicator.setMakeAccessible(false);
            mixinApplicator.setNoMixinIsError(true);
        }
        return mixinApplicator;
    }

    static {
        DUMP = !System.getProperty(DUMP_PROPERTY_NAME, "").isEmpty();
        classLoaderInitialised = false;
        PatcherLog.info("ModPatcher running under classloader " + ModPatcherTransformer.class.getClassLoader().getClass().getName());
        ModPatcherTransformer.checkForMultipleClassLoads();
        try {
            pool = new ClassLoaderPool();
            patcher = new Patcher(pool, Patches.class, new MCPMappings());
            ModPatcherTransformer.recursivelyAddXmlFiles(new File(MOD_PATCHES_DIRECTORY), patcher);
        }
        catch (Throwable t) {
            throw ModPatcherTransformer.logError("Failed to create Patcher", t);
        }
    }

    private static class ClassTransformer
    implements IClassTransformer {
        static IClassTransformer INSTANCE = new ClassTransformer();
        private boolean init;

        private ClassTransformer() {
        }

        private static void dumpIfEnabled(String name, byte[] data) {
            if (!DUMP || !name.contains("net.minecraft")) {
                return;
            }
            Path path = Paths.get("./DUMP/" + name + ".class", new String[0]);
            try {
                Files.createDirectories(path.getParent(), new FileAttribute[0]);
                Files.write(path, data, new OpenOption[0]);
            }
            catch (IOException e) {
                PatcherLog.error("Failed to dump class " + name, e);
            }
        }

        public byte[] transform(String name, String transformedName, byte[] bytes) {
            if (!this.init) {
                this.init = true;
                patcher.logDebugInfo();
            }
            ClassTransformer.dumpIfEnabled(transformedName + "_unpatched", bytes);
            byte[] transformed = ModPatcherTransformer.transformationHook(transformedName, bytes);
            if (bytes != transformed) {
                ClassTransformer.dumpIfEnabled(transformedName, transformed);
            }
            return transformed;
        }
    }
}

