/*
 * Decompiled with CFR 0.152.
 */
package me.nallar.javatransformer.internal;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import me.nallar.javatransformer.api.Parameter;
import me.nallar.javatransformer.api.TransformationException;
import me.nallar.javatransformer.api.Type;
import me.nallar.javatransformer.api.TypeVariable;
import me.nallar.javatransformer.internal.ResolutionContext;
import me.nallar.javatransformer.internal.util.TypeUtil;
import org.objectweb.asm.tree.MethodNode;

public class MethodDescriptor {
    private final List<TypeVariable> typeVariables;
    private final List<Parameter> parameters;
    private final Type returnType;

    public MethodDescriptor(List<TypeVariable> typeVariables, List<Parameter> parameters, Type returnType) {
        this.typeVariables = typeVariables;
        this.parameters = parameters;
        this.returnType = returnType;
    }

    public MethodDescriptor(String descriptor, String signature) {
        this(descriptor, signature, null);
    }

    public MethodDescriptor(String descriptor, String signature, List<String> parameterNames) {
        this(MethodDescriptor.getTypeVariables(signature), MethodDescriptor.getParameters(descriptor, signature, parameterNames), MethodDescriptor.getReturnType(descriptor, signature));
    }

    private static List<TypeVariable> getTypeVariables(String signature) {
        if (signature == null) {
            return Collections.emptyList();
        }
        String before = MethodDescriptor.before('(', signature);
        String typeArguments = ResolutionContext.extractGeneric(before);
        if (typeArguments == null) {
            return Collections.emptyList();
        }
        ArrayList<TypeVariable> list = new ArrayList<TypeVariable>();
        int pos = 0;
        int start = 0;
        while (pos < typeArguments.length()) {
            char c = typeArguments.charAt(pos++);
            switch (c) {
                case ':': {
                    String name = typeArguments.substring(start, pos);
                    String bounds = TypeUtil.readType(typeArguments, pos, true);
                    pos += bounds.length();
                    list.add(new TypeVariable(name, Type.ofSignature(bounds)));
                }
            }
        }
        return list;
    }

    private static Type getReturnType(String descriptor, String signature) {
        String returnDescriptor = MethodDescriptor.after(')', descriptor);
        String returnSignature = null;
        if (signature != null) {
            returnSignature = MethodDescriptor.after(')', signature);
        }
        return new Type(returnDescriptor, returnSignature);
    }

    private static List<Parameter> getParameters(String descriptor, String signature, List<String> parameterNames) {
        ArrayList<Parameter> parameters = new ArrayList<Parameter>();
        List<Type> parameterTypes = Type.listOf(MethodDescriptor.getParameters(descriptor), MethodDescriptor.getParameters(signature));
        for (int i = 0; i < parameterTypes.size(); ++i) {
            String name = parameterNames == null || parameterNames.isEmpty() ? null : parameterNames.get(i);
            parameters.add(new Parameter(parameterTypes.get(i), name));
        }
        return parameters;
    }

    private static String getParameters(String descriptor) {
        if (descriptor == null) {
            return null;
        }
        return MethodDescriptor.before(')', MethodDescriptor.after('(', descriptor));
    }

    private static String before(char c, String in) {
        int index = in.indexOf(c);
        if (index == -1) {
            throw new TransformationException("Could not find '" + c + "' in '" + in + "'");
        }
        return in.substring(0, index);
    }

    private static String after(char c, String in) {
        int index = in.indexOf(c);
        if (index == -1) {
            throw new TransformationException("Could not find '" + c + "' in '" + in + "'");
        }
        return in.substring(index + 1, in.length());
    }

    public MethodDescriptor withTypeVariables(List<TypeVariable> typeVariables) {
        return new MethodDescriptor(typeVariables, this.parameters, this.returnType);
    }

    public MethodDescriptor withParameters(List<Parameter> parameters) {
        return new MethodDescriptor(this.typeVariables, parameters, this.returnType);
    }

    public MethodDescriptor withReturnType(Type returnType) {
        return new MethodDescriptor(this.typeVariables, this.parameters, returnType);
    }

    public void saveTo(MethodNode node) {
        node.desc = this.getDescriptor();
        node.signature = this.getSignature();
    }

    public String getDescriptor() {
        StringBuilder desc = new StringBuilder("(");
        for (Parameter parameter : this.parameters) {
            desc.append(parameter.descriptor);
        }
        desc.append(")").append(this.returnType.descriptor);
        return desc.toString();
    }

    private String getSignature() {
        boolean any = false;
        StringBuilder signature = new StringBuilder();
        List<TypeVariable> typeVariables = this.getTypeVariables();
        if (!typeVariables.isEmpty()) {
            signature.append('<');
            typeVariables.forEach(signature::append);
            signature.append('>');
        }
        signature.append("(");
        for (Parameter parameter : this.parameters) {
            String generic = parameter.signature;
            if (generic == null) {
                generic = parameter.descriptor;
            } else {
                any = true;
            }
            signature.append(generic);
        }
        signature.append(")");
        String generic = this.returnType.signature;
        if (generic == null) {
            generic = this.returnType.descriptor;
        } else {
            any = true;
        }
        signature.append(generic);
        if (any) {
            return signature.toString();
        }
        return null;
    }

    public List<TypeVariable> getTypeVariables() {
        return this.typeVariables;
    }

    public List<Parameter> getParameters() {
        return this.parameters;
    }

    public Type getReturnType() {
        return this.returnType;
    }

    public String toString() {
        return "MethodDescriptor(typeVariables=" + this.getTypeVariables() + ", parameters=" + this.getParameters() + ", returnType=" + this.getReturnType() + ")";
    }
}

